/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.Group;
import java.beans.ConstructorProperties;

public class CreateGroupResponse {
    private String opcRequestId;
    private String etag;
    private Group group;

    @ConstructorProperties(value={"opcRequestId", "etag", "group"})
    CreateGroupResponse(String opcRequestId, String etag, Group group) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.group = group;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Group getGroup() {
        return this.group;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Group group;

        public Builder copy(CreateGroupResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.group(o.getGroup());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder group(Group group) {
            this.group = group;
            return this;
        }

        public CreateGroupResponse build() {
            return new CreateGroupResponse(this.opcRequestId, this.etag, this.group);
        }

        public String toString() {
            return "CreateGroupResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", group=" + this.group + ")";
        }
    }
}

