/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.IdentityProvider;
import java.beans.ConstructorProperties;

public class CreateIdentityProviderResponse {
    private String opcRequestId;
    private String etag;
    private IdentityProvider identityProvider;

    @ConstructorProperties(value={"opcRequestId", "etag", "identityProvider"})
    CreateIdentityProviderResponse(String opcRequestId, String etag, IdentityProvider identityProvider) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.identityProvider = identityProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private IdentityProvider identityProvider;

        public Builder copy(CreateIdentityProviderResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.identityProvider(o.getIdentityProvider());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public CreateIdentityProviderResponse build() {
            return new CreateIdentityProviderResponse(this.opcRequestId, this.etag, this.identityProvider);
        }

        public String toString() {
            return "CreateIdentityProviderResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", identityProvider=" + this.identityProvider + ")";
        }
    }
}

