/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.RegionSubscription;
import java.beans.ConstructorProperties;

public class CreateRegionSubscriptionResponse {
    private String opcRequestId;
    private RegionSubscription regionSubscription;

    @ConstructorProperties(value={"opcRequestId", "regionSubscription"})
    CreateRegionSubscriptionResponse(String opcRequestId, RegionSubscription regionSubscription) {
        this.opcRequestId = opcRequestId;
        this.regionSubscription = regionSubscription;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RegionSubscription getRegionSubscription() {
        return this.regionSubscription;
    }

    public static class Builder {
        private String opcRequestId;
        private RegionSubscription regionSubscription;

        public Builder copy(CreateRegionSubscriptionResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.regionSubscription(o.getRegionSubscription());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder regionSubscription(RegionSubscription regionSubscription) {
            this.regionSubscription = regionSubscription;
            return this;
        }

        public CreateRegionSubscriptionResponse build() {
            return new CreateRegionSubscriptionResponse(this.opcRequestId, this.regionSubscription);
        }

        public String toString() {
            return "CreateRegionSubscriptionResponse.Builder(opcRequestId=" + this.opcRequestId + ", regionSubscription=" + this.regionSubscription + ")";
        }
    }
}

