/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.SwiftPassword;
import java.beans.ConstructorProperties;

public class CreateSwiftPasswordResponse {
    private String opcRequestId;
    private String etag;
    private SwiftPassword swiftPassword;

    @ConstructorProperties(value={"opcRequestId", "etag", "swiftPassword"})
    CreateSwiftPasswordResponse(String opcRequestId, String etag, SwiftPassword swiftPassword) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.swiftPassword = swiftPassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public SwiftPassword getSwiftPassword() {
        return this.swiftPassword;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private SwiftPassword swiftPassword;

        public Builder copy(CreateSwiftPasswordResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.swiftPassword(o.getSwiftPassword());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder swiftPassword(SwiftPassword swiftPassword) {
            this.swiftPassword = swiftPassword;
            return this;
        }

        public CreateSwiftPasswordResponse build() {
            return new CreateSwiftPasswordResponse(this.opcRequestId, this.etag, this.swiftPassword);
        }

        public String toString() {
            return "CreateSwiftPasswordResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", swiftPassword=" + this.swiftPassword + ")";
        }
    }
}

