/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.MfaTotpDevice;
import java.beans.ConstructorProperties;

public class GenerateTotpSeedResponse {
    private String opcRequestId;
    private String etag;
    private MfaTotpDevice mfaTotpDevice;

    @ConstructorProperties(value={"opcRequestId", "etag", "mfaTotpDevice"})
    GenerateTotpSeedResponse(String opcRequestId, String etag, MfaTotpDevice mfaTotpDevice) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.mfaTotpDevice = mfaTotpDevice;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public MfaTotpDevice getMfaTotpDevice() {
        return this.mfaTotpDevice;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private MfaTotpDevice mfaTotpDevice;

        public Builder copy(GenerateTotpSeedResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.mfaTotpDevice(o.getMfaTotpDevice());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder mfaTotpDevice(MfaTotpDevice mfaTotpDevice) {
            this.mfaTotpDevice = mfaTotpDevice;
            return this;
        }

        public GenerateTotpSeedResponse build() {
            return new GenerateTotpSeedResponse(this.opcRequestId, this.etag, this.mfaTotpDevice);
        }

        public String toString() {
            return "GenerateTotpSeedResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", mfaTotpDevice=" + this.mfaTotpDevice + ")";
        }
    }
}

