/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.Compartment;
import java.beans.ConstructorProperties;

public class GetCompartmentResponse {
    private String opcRequestId;
    private String etag;
    private Compartment compartment;

    @ConstructorProperties(value={"opcRequestId", "etag", "compartment"})
    GetCompartmentResponse(String opcRequestId, String etag, Compartment compartment) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.compartment = compartment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Compartment getCompartment() {
        return this.compartment;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Compartment compartment;

        public Builder copy(GetCompartmentResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.compartment(o.getCompartment());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder compartment(Compartment compartment) {
            this.compartment = compartment;
            return this;
        }

        public GetCompartmentResponse build() {
            return new GetCompartmentResponse(this.opcRequestId, this.etag, this.compartment);
        }

        public String toString() {
            return "GetCompartmentResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", compartment=" + this.compartment + ")";
        }
    }
}

