/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.Tenancy;
import java.beans.ConstructorProperties;

public class GetTenancyResponse {
    private String opcRequestId;
    private Tenancy tenancy;

    @ConstructorProperties(value={"opcRequestId", "tenancy"})
    GetTenancyResponse(String opcRequestId, Tenancy tenancy) {
        this.opcRequestId = opcRequestId;
        this.tenancy = tenancy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Tenancy getTenancy() {
        return this.tenancy;
    }

    public static class Builder {
        private String opcRequestId;
        private Tenancy tenancy;

        public Builder copy(GetTenancyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.tenancy(o.getTenancy());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder tenancy(Tenancy tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        public GetTenancyResponse build() {
            return new GetTenancyResponse(this.opcRequestId, this.tenancy);
        }

        public String toString() {
            return "GetTenancyResponse.Builder(opcRequestId=" + this.opcRequestId + ", tenancy=" + this.tenancy + ")";
        }
    }
}

