/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.WorkRequest;
import java.beans.ConstructorProperties;

public class GetWorkRequestResponse {
    private String opcRequestId;
    private Float retryAfter;
    private WorkRequest workRequest;

    @ConstructorProperties(value={"opcRequestId", "retryAfter", "workRequest"})
    GetWorkRequestResponse(String opcRequestId, Float retryAfter, WorkRequest workRequest) {
        this.opcRequestId = opcRequestId;
        this.retryAfter = retryAfter;
        this.workRequest = workRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public WorkRequest getWorkRequest() {
        return this.workRequest;
    }

    public static class Builder {
        private String opcRequestId;
        private Float retryAfter;
        private WorkRequest workRequest;

        public Builder copy(GetWorkRequestResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.retryAfter(o.getRetryAfter());
            this.workRequest(o.getWorkRequest());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder workRequest(WorkRequest workRequest) {
            this.workRequest = workRequest;
            return this;
        }

        public GetWorkRequestResponse build() {
            return new GetWorkRequestResponse(this.opcRequestId, this.retryAfter, this.workRequest);
        }

        public String toString() {
            return "GetWorkRequestResponse.Builder(opcRequestId=" + this.opcRequestId + ", retryAfter=" + this.retryAfter + ", workRequest=" + this.workRequest + ")";
        }
    }
}

