/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.FaultDomain;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListFaultDomainsResponse {
    private String opcRequestId;
    private List<FaultDomain> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListFaultDomainsResponse(String opcRequestId, List<FaultDomain> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<FaultDomain> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<FaultDomain> items;

        public Builder copy(ListFaultDomainsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<FaultDomain> items) {
            this.items = items;
            return this;
        }

        public ListFaultDomainsResponse build() {
            return new ListFaultDomainsResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListFaultDomainsResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

