/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.RegionSubscription;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListRegionSubscriptionsResponse {
    private String opcRequestId;
    private List<RegionSubscription> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListRegionSubscriptionsResponse(String opcRequestId, List<RegionSubscription> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<RegionSubscription> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<RegionSubscription> items;

        public Builder copy(ListRegionSubscriptionsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<RegionSubscription> items) {
            this.items = items;
            return this;
        }

        public ListRegionSubscriptionsResponse build() {
            return new ListRegionSubscriptionsResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListRegionSubscriptionsResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

