/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.AuthenticationPolicy;
import java.beans.ConstructorProperties;

public class UpdateAuthenticationPolicyResponse {
    private String opcRequestId;
    private String etag;
    private AuthenticationPolicy authenticationPolicy;

    @ConstructorProperties(value={"opcRequestId", "etag", "authenticationPolicy"})
    UpdateAuthenticationPolicyResponse(String opcRequestId, String etag, AuthenticationPolicy authenticationPolicy) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.authenticationPolicy = authenticationPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public AuthenticationPolicy getAuthenticationPolicy() {
        return this.authenticationPolicy;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private AuthenticationPolicy authenticationPolicy;

        public Builder copy(UpdateAuthenticationPolicyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.authenticationPolicy(o.getAuthenticationPolicy());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder authenticationPolicy(AuthenticationPolicy authenticationPolicy) {
            this.authenticationPolicy = authenticationPolicy;
            return this;
        }

        public UpdateAuthenticationPolicyResponse build() {
            return new UpdateAuthenticationPolicyResponse(this.opcRequestId, this.etag, this.authenticationPolicy);
        }

        public String toString() {
            return "UpdateAuthenticationPolicyResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", authenticationPolicy=" + this.authenticationPolicy + ")";
        }
    }
}

