/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.IdpGroupMapping;
import java.beans.ConstructorProperties;

public class UpdateIdpGroupMappingResponse {
    private String opcRequestId;
    private String etag;
    private IdpGroupMapping idpGroupMapping;

    @ConstructorProperties(value={"opcRequestId", "etag", "idpGroupMapping"})
    UpdateIdpGroupMappingResponse(String opcRequestId, String etag, IdpGroupMapping idpGroupMapping) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.idpGroupMapping = idpGroupMapping;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public IdpGroupMapping getIdpGroupMapping() {
        return this.idpGroupMapping;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private IdpGroupMapping idpGroupMapping;

        public Builder copy(UpdateIdpGroupMappingResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.idpGroupMapping(o.getIdpGroupMapping());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder idpGroupMapping(IdpGroupMapping idpGroupMapping) {
            this.idpGroupMapping = idpGroupMapping;
            return this;
        }

        public UpdateIdpGroupMappingResponse build() {
            return new UpdateIdpGroupMappingResponse(this.opcRequestId, this.etag, this.idpGroupMapping);
        }

        public String toString() {
            return "UpdateIdpGroupMappingResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", idpGroupMapping=" + this.idpGroupMapping + ")";
        }
    }
}

