/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.SmtpCredentialSummary;
import java.beans.ConstructorProperties;

public class UpdateSmtpCredentialResponse {
    private String opcRequestId;
    private String etag;
    private SmtpCredentialSummary smtpCredentialSummary;

    @ConstructorProperties(value={"opcRequestId", "etag", "smtpCredentialSummary"})
    UpdateSmtpCredentialResponse(String opcRequestId, String etag, SmtpCredentialSummary smtpCredentialSummary) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.smtpCredentialSummary = smtpCredentialSummary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public SmtpCredentialSummary getSmtpCredentialSummary() {
        return this.smtpCredentialSummary;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private SmtpCredentialSummary smtpCredentialSummary;

        public Builder copy(UpdateSmtpCredentialResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.smtpCredentialSummary(o.getSmtpCredentialSummary());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder smtpCredentialSummary(SmtpCredentialSummary smtpCredentialSummary) {
            this.smtpCredentialSummary = smtpCredentialSummary;
            return this;
        }

        public UpdateSmtpCredentialResponse build() {
            return new UpdateSmtpCredentialResponse(this.opcRequestId, this.etag, this.smtpCredentialSummary);
        }

        public String toString() {
            return "UpdateSmtpCredentialResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", smtpCredentialSummary=" + this.smtpCredentialSummary + ")";
        }
    }
}

