/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.Tag;
import java.beans.ConstructorProperties;

public class UpdateTagResponse {
    private String opcRequestId;
    private String etag;
    private Tag tag;

    @ConstructorProperties(value={"opcRequestId", "etag", "tag"})
    UpdateTagResponse(String opcRequestId, String etag, Tag tag) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.tag = tag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Tag getTag() {
        return this.tag;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Tag tag;

        public Builder copy(UpdateTagResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.tag(o.getTag());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public UpdateTagResponse build() {
            return new UpdateTagResponse(this.opcRequestId, this.etag, this.tag);
        }

        public String toString() {
            return "UpdateTagResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", tag=" + this.tag + ")";
        }
    }
}

