/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.responses;

import com.oracle.bmc.identity.model.ApiKey;
import java.beans.ConstructorProperties;

public class UploadApiKeyResponse {
    private String opcRequestId;
    private String etag;
    private ApiKey apiKey;

    @ConstructorProperties(value={"opcRequestId", "etag", "apiKey"})
    UploadApiKeyResponse(String opcRequestId, String etag, ApiKey apiKey) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.apiKey = apiKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public ApiKey getApiKey() {
        return this.apiKey;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private ApiKey apiKey;

        public Builder copy(UploadApiKeyResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.apiKey(o.getApiKey());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public UploadApiKeyResponse build() {
            return new UploadApiKeyResponse(this.opcRequestId, this.etag, this.apiKey);
        }

        public String toString() {
            return "UploadApiKeyResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", apiKey=" + this.apiKey + ")";
        }
    }
}

