/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.elf.ELFObjectFile;
import com.oracle.objectfile.elf.ELFSymtab;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.io.OutputAssembler;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;

public class ELFRelocationSection
extends ELFObjectFile.ELFSection {
    private final boolean withExplicitAddends;
    private final ELFObjectFile.ELFSection relocated;
    private final ELFSymtab syms;
    private final Map<Entry, Entry> entries;

    @Override
    public ElementImpl getImpl() {
        return this;
    }

    ELFRelocationSection(ELFObjectFile owner, String name, ELFObjectFile.ELFSection relocated, ELFSymtab syms, boolean withExplicitAddends) {
        ELFObjectFile eLFObjectFile = owner;
        eLFObjectFile.getClass();
        super(name, owner.getWordSizeInBytes(), withExplicitAddends ? ELFObjectFile.SectionType.RELA : ELFObjectFile.SectionType.REL, EnumSet.noneOf(ELFObjectFile.ELFSectionFlag.class), -1);
        this.entries = new TreeMap<Entry, Entry>(Comparator.comparingLong(Entry::getOffset));
        this.withExplicitAddends = withExplicitAddends;
        this.syms = syms;
        this.relocated = relocated;
        if (relocated == null) {
            assert (syms == null || syms.isDynamic());
            this.flags.add(ELFObjectFile.ELFSectionFlag.ALLOC);
        } else assert (name.equals((withExplicitAddends ? ".rela" : ".rel") + relocated.getName()));
    }

    public Entry addEntry(ELFObjectFile.ELFSection s, long offset, ELFRelocationMethod t, ELFSymtab.Entry sym, Long explicitAddend) {
        if (explicitAddend != null) {
            if (!t.canUseExplicitAddend()) {
                throw new IllegalArgumentException("cannot use relocation method " + t + " with explicit addends");
            }
            if (!this.withExplicitAddends) {
                throw new IllegalStateException("cannot create relocation with addend in .rel section");
            }
        } else {
            if (!t.canUseImplicitAddend()) {
                throw new IllegalArgumentException("cannot use relocation method " + t + " with implicit addends");
            }
            if (this.withExplicitAddends) {
                throw new IllegalStateException("cannot create relocation without addend in .rela section");
            }
        }
        long addend = explicitAddend != null ? explicitAddend : 0L;
        return this.entries.computeIfAbsent(new Entry(s, offset, t, sym, addend), Function.identity());
    }

    public boolean isDynamic() {
        return this.syms.isDynamic();
    }

    @Override
    public ELFObjectFile.ELFSection getLinkedSection() {
        return this.syms;
    }

    @Override
    public long getLinkedInfo() {
        return this.relocated == null ? 0L : (long)this.getOwner().getIndexForSection(this.relocated);
    }

    @Override
    public int getEntrySize() {
        return new EntryStruct().getWrittenSize();
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        HashSet<BuildDependency> deps = ObjectFile.minimalDependencies(decisions, this);
        LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
        if (this.isDynamic()) {
            HashSet<ELFObjectFile.ELFSection> referenced = new HashSet<ELFObjectFile.ELFSection>();
            for (Entry ent : this.entries.keySet()) {
                referenced.add(ent.section);
            }
            for (ELFObjectFile.ELFSection es : referenced) {
                deps.add(BuildDependency.createOrGet(ourContent, decisions.get(es).getDecision(LayoutDecision.Kind.VADDR)));
            }
        }
        return deps;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        OutputAssembler oa = AssemblyBuffer.createOutputAssembler(ByteBuffer.allocate(this.entries.size() * new EntryStruct().getWrittenSize()).order(this.getOwner().getByteOrder()));
        for (Entry ent : this.entries.keySet()) {
            long info;
            long offset = !this.isDynamic() ? ent.offset : (long)((Integer)alreadyDecided.get(ent.section).getDecidedValue(LayoutDecision.Kind.VADDR)).intValue() + ent.offset;
            int symIndex = this.syms.indexOf(ent.sym);
            assert (symIndex >= 0) : "symbol not found";
            switch (this.getOwner().getFileClass()) {
                case ELFCLASS32: {
                    info = ((long)(symIndex << 8) & 0xFFFFFFFFL) + (ent.t.toLong() & 0xFFL);
                    break;
                }
                case ELFCLASS64: {
                    info = ((long)symIndex << 32) + (ent.t.toLong() & 0xFFFFFFFFL);
                    break;
                }
                default: {
                    throw new RuntimeException(this.getOwner().getFileClass().toString());
                }
            }
            long addend = ent.addend;
            new EntryStruct(offset, info, addend).write(oa);
        }
        return oa.getBlob();
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        return ObjectFile.defaultGetOrDecideOffset(alreadyDecided, this, offsetHint);
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.entries.size() * new EntryStruct().getWrittenSize();
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return ObjectFile.defaultDecisions(this, copyingIn);
    }

    private static final class Entry
    implements ObjectFile.RelocationRecord {
        final ELFObjectFile.ELFSection section;
        final long offset;
        final ELFRelocationMethod t;
        final ELFSymtab.Entry sym;
        final long addend;

        Entry(ELFObjectFile.ELFSection section, long offset, ELFRelocationMethod t, ELFSymtab.Entry sym, long addend) {
            this.section = section;
            this.offset = offset;
            this.t = t;
            this.sym = sym;
            this.addend = addend;
        }

        @Override
        public ObjectFile.RelocationKind getKind() {
            return this.t.getKind();
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        @Override
        public ObjectFile.Symbol getReferencedSymbol() {
            return this.sym;
        }

        @Override
        public int getRelocatedByteSize() {
            return this.t.getRelocatedByteSize();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                Entry other = (Entry)obj;
                return Objects.equals(this.section, other.section) && this.offset == other.offset && Objects.equals(this.t, other.t) && Objects.equals(this.sym, other.sym) && this.addend == other.addend;
            }
            return false;
        }

        public int hashCode() {
            return (((this.section.hashCode() * 31 + Long.hashCode(this.offset)) * 31 + this.t.hashCode()) * 31 + this.sym.hashCode()) * 31 + Long.hashCode(this.addend);
        }
    }

    static interface ELFRelocationMethod
    extends ObjectFile.RelocationMethod {
        public long toLong();
    }

    class EntryStruct {
        long offset;
        long info;
        long addend;

        EntryStruct() {
        }

        EntryStruct(long offset, long info, long addend) {
            this.offset = offset;
            this.info = info;
            if (ELFRelocationSection.this.withExplicitAddends) {
                this.addend = addend;
            }
        }

        void write(OutputAssembler oa) {
            switch (ELFRelocationSection.this.getOwner().getFileClass()) {
                case ELFCLASS32: {
                    oa.write4Byte(Math.toIntExact(this.offset));
                    oa.write4Byte(Math.toIntExact(this.info));
                    if (!ELFRelocationSection.this.withExplicitAddends) break;
                    oa.write4Byte(Math.toIntExact(this.addend));
                    break;
                }
                case ELFCLASS64: {
                    oa.write8Byte(this.offset);
                    oa.write8Byte(this.info);
                    if (!ELFRelocationSection.this.withExplicitAddends) break;
                    oa.write8Byte(this.addend);
                    break;
                }
                default: {
                    throw new RuntimeException(ELFRelocationSection.this.getOwner().getFileClass().toString());
                }
            }
        }

        int getWrittenSize() {
            ByteBuffer bb = ByteBuffer.allocate(24);
            this.write(AssemblyBuffer.createOutputAssembler(bb));
            return bb.position();
        }
    }
}

