/*
 * Copyright (C) 2015 Orange
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *          http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.orange.ngsi.exception;

/**
 * Created by pborscia on 08/07/2015.
 */
public class UnsupportedOperationException extends Exception {

    private final String operationName;

    public UnsupportedOperationException(String operationName) {
        super("");
        this.operationName = operationName;
    }


    @Override
    public String getMessage() {
        return "This " + this.operationName + " operation is not supported.";
    }

    public String getOperationName() {
        return operationName;
    }

}
