/*
 * Copyright (C) 2015 Orange
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *          http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.orange.ngsi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/**
 * UpdateContextSubscriptionResponse
 */
@JacksonXmlRootElement(localName = "updateContextSubscriptionResponse")
public class UpdateContextSubscriptionResponse {

    private SubscribeResponse subscribeResponse;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private SubscribeError subscribeError;

    public UpdateContextSubscriptionResponse() {
    }

    public UpdateContextSubscriptionResponse(SubscribeResponse subscribeResponse) {
        this.subscribeResponse = subscribeResponse;
    }

    public UpdateContextSubscriptionResponse(SubscribeError subscribeError) {
        this.subscribeError = subscribeError;
    }

    public SubscribeResponse getSubscribeResponse() {
        return subscribeResponse;
    }

    public void setSubscribeResponse(SubscribeResponse subscribeResponse) {
        this.subscribeResponse = subscribeResponse;
    }

    public SubscribeError getSubscribeError() {
        return subscribeError;
    }

    public void setSubscribeError(SubscribeError subscribeError) {
        this.subscribeError = subscribeError;
    }

    @Override
    public String toString() {
        return "UpdateContextSubscriptionResponse{" +
                "subscribeResponse=" + subscribeResponse +
                ", subscribeError=" + subscribeError +
                '}';
    }
}
