/*
 * Decompiled with CFR 0.152.
 */
package com.orange.ngsi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProtocolRegistry {
    private static Logger logger = LoggerFactory.getLogger(ProtocolRegistry.class);
    private Map<String, Boolean> jsonHost = new HashMap<String, Boolean>();

    public void registerHost(String url, boolean v1) {
        try {
            this.jsonHost.put(this.getHost(url), v1);
        }
        catch (URISyntaxException e) {
            logger.warn("failed to register url {}", (Object)url);
        }
    }

    public void unregisterHost(String url) {
        try {
            this.jsonHost.remove(this.getHost(url));
        }
        catch (URISyntaxException e) {
            logger.warn("failed to register url {}", (Object)url);
        }
    }

    public boolean supportV1Json(String url) {
        try {
            Boolean result = this.jsonHost.get(this.getHost(url));
            return result != null && result != false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public boolean supportV2Json(String url) throws URISyntaxException {
        try {
            Boolean result = this.jsonHost.get(this.getHost(url));
            return result != null && result == false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public boolean supportXml(String url) {
        try {
            return this.jsonHost.get(this.getHost(url)) == null;
        }
        catch (URISyntaxException e) {
            return true;
        }
    }

    private String getHost(String url) throws URISyntaxException {
        URI uri = new URI(url);
        return uri.getHost() + ":" + uri.getPort();
    }
}

