/*
 * Decompiled with CFR 0.152.
 */
package com.orange.ngsi.client;

import javax.annotation.Resource;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.AsyncRestTemplate;

@Configuration
public class HttpConfiguration {
    @Value(value="${ngsi.http.maxTotalConnections:20}")
    private int maxTotalConnections;
    @Value(value="${ngsi.http.maxConnectionsPerRoute:2}")
    private int maxConnectionsPerRoute;
    @Value(value="${ngsi.http.requestTimeout:2000}")
    private int requestTimeout;

    @Bean
    @Resource(name="jsonV1Converter")
    public AsyncRestTemplate asyncRestTemplate(AsyncClientHttpRequestFactory asyncClientHttpRequestFactory, MappingJackson2HttpMessageConverter jsonConverter) {
        AsyncRestTemplate restTemplate = new AsyncRestTemplate(asyncClientHttpRequestFactory);
        for (HttpMessageConverter httpMessageConverter : restTemplate.getMessageConverters()) {
            if (!(httpMessageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            restTemplate.getMessageConverters().remove(httpMessageConverter);
            break;
        }
        restTemplate.getMessageConverters().add(jsonConverter);
        return restTemplate;
    }

    @Bean
    public AsyncClientHttpRequestFactory clientHttpRequestFactory(CloseableHttpAsyncClient closeableHttpAsyncClient) {
        return new HttpComponentsAsyncClientHttpRequestFactory(closeableHttpAsyncClient);
    }

    @Bean
    public CloseableHttpAsyncClient asyncHttpClient(PoolingNHttpClientConnectionManager poolingNHttpClientConnectionManager) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.requestTimeout).setSocketTimeout(this.requestTimeout).setConnectionRequestTimeout(this.requestTimeout).build();
        return HttpAsyncClientBuilder.create().setConnectionManager((NHttpClientConnectionManager)poolingNHttpClientConnectionManager).setDefaultRequestConfig(config).build();
    }

    @Bean
    PoolingNHttpClientConnectionManager poolingNHttpClientConnectionManager() throws IOReactorException {
        PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor(IOReactorConfig.DEFAULT));
        connectionManager.setMaxTotal(this.maxTotalConnections);
        connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        return connectionManager;
    }
}

