/*
 * Decompiled with CFR 0.152.
 */
package com.orange.ngsi.client;

import com.orange.ngsi.client.NgsiClient;
import com.orange.ngsi.model.AppendContextElement;
import com.orange.ngsi.model.AppendContextElementResponse;
import com.orange.ngsi.model.ContextAttributeResponse;
import com.orange.ngsi.model.ContextElementResponse;
import com.orange.ngsi.model.QueryContextResponse;
import com.orange.ngsi.model.StatusCode;
import com.orange.ngsi.model.SubscribeContext;
import com.orange.ngsi.model.SubscribeContextResponse;
import com.orange.ngsi.model.UnsubscribeContextResponse;
import com.orange.ngsi.model.UpdateContextAttribute;
import com.orange.ngsi.model.UpdateContextElement;
import com.orange.ngsi.model.UpdateContextElementResponse;
import com.orange.ngsi.model.UpdateContextSubscription;
import com.orange.ngsi.model.UpdateContextSubscriptionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;

@Service
public class NgsiRestClient
extends NgsiClient {
    private static Logger logger = LoggerFactory.getLogger(NgsiRestClient.class);
    private static final String basePath = "/ngsi10";
    private static final String entitiesPath = "/ngsi10/contextEntities/";
    private static final String entityTypesPath = "/ngsi10/contextEntityTypes/";
    private static final String subscriptionsPath = "/ngsi10/contextSubscriptions/";
    private static final String attributesPath = "/attributes/";
    private static final String valuesPath = "/";

    public ListenableFuture<AppendContextElementResponse> appendContextElement(String url, HttpHeaders httpHeaders, String entityID, AppendContextElement appendContextElement) {
        return this.request(HttpMethod.POST, url + entitiesPath + entityID, httpHeaders, appendContextElement, AppendContextElementResponse.class);
    }

    public ListenableFuture<UpdateContextElementResponse> updateContextElement(String url, HttpHeaders httpHeaders, String entityID, UpdateContextElement updateContextElement) {
        return this.request(HttpMethod.PUT, url + entitiesPath + entityID, httpHeaders, updateContextElement, UpdateContextElementResponse.class);
    }

    public ListenableFuture<ContextElementResponse> getContextElement(String url, HttpHeaders httpHeaders, String entityID) {
        return this.request(HttpMethod.GET, url + entitiesPath + entityID, httpHeaders, null, ContextElementResponse.class);
    }

    public ListenableFuture<StatusCode> deleteContextElement(String url, HttpHeaders httpHeaders, String entityID) {
        return this.request(HttpMethod.DELETE, url + entitiesPath + entityID, httpHeaders, null, StatusCode.class);
    }

    public ListenableFuture<StatusCode> appendContextAttribute(String url, HttpHeaders httpHeaders, String entityID, String attributeName, UpdateContextAttribute updateContextAttribute) {
        return this.request(HttpMethod.POST, url + entitiesPath + entityID + attributesPath + attributeName, httpHeaders, updateContextAttribute, StatusCode.class);
    }

    public ListenableFuture<StatusCode> updateContextAttribute(String url, HttpHeaders httpHeaders, String entityID, String attributeName, UpdateContextAttribute updateContextAttribute) {
        return this.request(HttpMethod.PUT, url + entitiesPath + entityID + attributesPath + attributeName, httpHeaders, updateContextAttribute, StatusCode.class);
    }

    public ListenableFuture<ContextAttributeResponse> getContextAttribute(String url, HttpHeaders httpHeaders, String entityID, String attributeName) {
        return this.request(HttpMethod.GET, url + entitiesPath + entityID + attributesPath + attributeName, httpHeaders, null, ContextAttributeResponse.class);
    }

    public ListenableFuture<StatusCode> deleteContextAttribute(String url, HttpHeaders httpHeaders, String entityID, String attributeName) {
        return this.request(HttpMethod.DELETE, url + entitiesPath + entityID + attributesPath + attributeName, httpHeaders, null, StatusCode.class);
    }

    public ListenableFuture<StatusCode> updateContextAttributeValue(String url, HttpHeaders httpHeaders, String entityID, String attributeName, String valueID, UpdateContextAttribute updateContextAttribute) {
        return this.request(HttpMethod.PUT, url + entitiesPath + entityID + attributesPath + attributeName + valuesPath + valueID, httpHeaders, updateContextAttribute, StatusCode.class);
    }

    public ListenableFuture<ContextAttributeResponse> getContextAttributeValue(String url, HttpHeaders httpHeaders, String entityID, String attributeName, String valueID) {
        return this.request(HttpMethod.GET, url + entitiesPath + entityID + attributesPath + attributeName + valuesPath + valueID, httpHeaders, null, ContextAttributeResponse.class);
    }

    public ListenableFuture<StatusCode> deleteContextAttributeValue(String url, HttpHeaders httpHeaders, String entityID, String attributeName, String valueID) {
        return this.request(HttpMethod.DELETE, url + entitiesPath + entityID + attributesPath + attributeName + valuesPath + valueID, httpHeaders, null, StatusCode.class);
    }

    public ListenableFuture<QueryContextResponse> getContextEntityType(String url, HttpHeaders httpHeaders, String typeName) {
        return this.request(HttpMethod.GET, url + entityTypesPath + typeName, httpHeaders, null, QueryContextResponse.class);
    }

    public ListenableFuture<QueryContextResponse> getContextEntityTypeAttribute(String url, HttpHeaders httpHeaders, String typeName, String attributeName) {
        return this.request(HttpMethod.GET, url + entityTypesPath + typeName + attributesPath + attributeName, httpHeaders, null, QueryContextResponse.class);
    }

    public ListenableFuture<SubscribeContextResponse> appendContextSubscription(String url, HttpHeaders httpHeaders, SubscribeContext subscribeContext) {
        return this.request(HttpMethod.POST, url + subscriptionsPath, httpHeaders, subscribeContext, SubscribeContextResponse.class);
    }

    public ListenableFuture<UpdateContextSubscriptionResponse> updateContextSubscription(String url, HttpHeaders httpHeaders, String subscriptionID, UpdateContextSubscription updateContextSubscription) {
        return this.request(HttpMethod.PUT, url + subscriptionsPath + subscriptionID, httpHeaders, updateContextSubscription, UpdateContextSubscriptionResponse.class);
    }

    public ListenableFuture<UnsubscribeContextResponse> deleteContextSubscription(String url, HttpHeaders httpHeaders, String subscriptionID) {
        return this.request(HttpMethod.DELETE, url + subscriptionsPath + subscriptionID, httpHeaders, null, UnsubscribeContextResponse.class);
    }
}

