/*
 * Decompiled with CFR 0.152.
 */
package com.orange.ngsi;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.orange.ngsi.model.AppendContextElementResponse;
import com.orange.ngsi.model.ContextElement;
import com.orange.ngsi.model.EntityIdMixIn;
import java.io.IOException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
public class ConvertersConfiguration {
    @Bean
    public MappingJackson2HttpMessageConverter jsonV1Converter(ObjectMapper objectMapper) {
        objectMapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
        SimpleModule booleanAsString = new SimpleModule("BooleanAsString");
        booleanAsString.addSerializer(Boolean.class, (JsonSerializer)new JsonSerializer<Boolean>(){

            public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(value.toString());
            }
        });
        objectMapper.registerModule((Module)booleanAsString);
        objectMapper.addMixIn(ContextElement.class, EntityIdMixIn.class);
        objectMapper.addMixIn(AppendContextElementResponse.class, EntityIdMixIn.class);
        return new MappingJackson2HttpMessageConverter(objectMapper);
    }
}

