/*
 * Decompiled with CFR 0.152.
 */
package com.orange.ngsi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProtocolRegistry {
    private static Logger logger = LoggerFactory.getLogger(ProtocolRegistry.class);
    private Set<String> xmlHost = new HashSet<String>();

    public void registerHost(String url) {
        try {
            this.xmlHost.add(this.getHost(url));
        }
        catch (URISyntaxException e) {
            logger.warn("failed to register url {}", (Object)url);
        }
    }

    public void unregisterHost(String url) {
        try {
            this.xmlHost.remove(this.getHost(url));
        }
        catch (URISyntaxException e) {
            logger.warn("failed to register url {}", (Object)url);
        }
    }

    public boolean supportV1Json(String url) {
        try {
            return !this.xmlHost.contains(this.getHost(url));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public boolean supportXml(String url) {
        try {
            return this.xmlHost.contains(this.getHost(url));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private String getHost(String url) throws URISyntaxException {
        URI uri = new URI(url);
        return uri.getHost() + ":" + uri.getPort();
    }
}

