/*
 * Decompiled with CFR 0.152.
 */
package com.orange.ngsi.client;

import com.orange.ngsi.ProtocolRegistry;
import com.orange.ngsi.model.NotifyContext;
import com.orange.ngsi.model.NotifyContextResponse;
import com.orange.ngsi.model.QueryContext;
import com.orange.ngsi.model.QueryContextResponse;
import com.orange.ngsi.model.RegisterContext;
import com.orange.ngsi.model.RegisterContextResponse;
import com.orange.ngsi.model.SubscribeContext;
import com.orange.ngsi.model.SubscribeContextResponse;
import com.orange.ngsi.model.UnsubscribeContext;
import com.orange.ngsi.model.UnsubscribeContextResponse;
import com.orange.ngsi.model.UpdateContext;
import com.orange.ngsi.model.UpdateContextResponse;
import com.orange.ngsi.model.UpdateContextSubscription;
import com.orange.ngsi.model.UpdateContextSubscriptionResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureAdapter;
import org.springframework.web.client.AsyncRestTemplate;

@Service
public class NgsiClient {
    private static Logger logger = LoggerFactory.getLogger(NgsiClient.class);
    @Autowired
    public AsyncRestTemplate asyncRestTemplate;
    @Autowired
    public PoolingNHttpClientConnectionManager poolingNHttpClientConnectionManager;
    @Autowired
    public ProtocolRegistry protocolRegistry;

    public void shutdownGracefully() throws IOException {
        this.poolingNHttpClientConnectionManager.shutdown(10000L);
    }

    public ListenableFuture<UpdateContextResponse> updateContext(String url, HttpHeaders httpHeaders, UpdateContext updateContext) {
        return this.request(url + "/ngsi10/updateContext", httpHeaders, updateContext, UpdateContextResponse.class);
    }

    public ListenableFuture<SubscribeContextResponse> subscribeContext(String url, HttpHeaders httpHeaders, SubscribeContext subscribeContext) {
        return this.request(url + "/ngsi10/subscribeContext", httpHeaders, subscribeContext, SubscribeContextResponse.class);
    }

    public ListenableFuture<UpdateContextSubscriptionResponse> updateContextSubscription(String url, HttpHeaders httpHeaders, UpdateContextSubscription updateContextSubscription) {
        return this.request(url + "/ngsi10/updateContextSubscription", httpHeaders, updateContextSubscription, UpdateContextSubscriptionResponse.class);
    }

    public ListenableFuture<UnsubscribeContextResponse> unsubscribeContext(String url, HttpHeaders httpHeaders, String subscriptionId) {
        return this.request(url + "/ngsi10/unsubscribeContext", httpHeaders, new UnsubscribeContext(subscriptionId), UnsubscribeContextResponse.class);
    }

    public ListenableFuture<NotifyContextResponse> notifyContext(String url, HttpHeaders httpHeaders, NotifyContext notifyContext) {
        return this.request(url + "/ngsi10/notifyContext", httpHeaders, notifyContext, NotifyContextResponse.class);
    }

    public ListenableFuture<NotifyContextResponse> notifyContextCustomURL(String customURL, HttpHeaders httpHeaders, NotifyContext notifyContext) {
        return this.request(customURL, httpHeaders, notifyContext, NotifyContextResponse.class);
    }

    public ListenableFuture<QueryContextResponse> queryContext(String url, HttpHeaders httpHeaders, QueryContext queryContext) {
        return this.request(url + "/ngsi10/queryContext", httpHeaders, queryContext, QueryContextResponse.class);
    }

    public ListenableFuture<RegisterContextResponse> registerContext(String url, HttpHeaders httpHeaders, RegisterContext registerContext) {
        return this.request(url + "/ngsi9/registerContext", httpHeaders, registerContext, RegisterContextResponse.class);
    }

    public HttpHeaders getRequestHeaders() {
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_XML);
        requestHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_XML));
        return requestHeaders;
    }

    public HttpHeaders getRequestHeaders(String url) {
        HttpHeaders requestHeaders = new HttpHeaders();
        MediaType mediaType = MediaType.APPLICATION_JSON;
        if (url == null || this.protocolRegistry.supportXml(url)) {
            mediaType = MediaType.APPLICATION_XML;
        }
        requestHeaders.setContentType(mediaType);
        requestHeaders.setAccept(Collections.singletonList(mediaType));
        return requestHeaders;
    }

    protected <T, U> ListenableFuture<T> request(String url, HttpHeaders httpHeaders, U body, Class<T> responseType) {
        return this.request(HttpMethod.POST, url, httpHeaders, body, responseType);
    }

    protected <T, U> ListenableFuture<T> request(HttpMethod method, String url, HttpHeaders httpHeaders, U body, Class<T> responseType) {
        if (httpHeaders == null) {
            httpHeaders = this.getRequestHeaders(url);
        }
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)httpHeaders);
        ListenableFuture future = this.asyncRestTemplate.exchange(url, method, requestEntity, responseType, new Object[0]);
        return new ListenableFutureAdapter<T, ResponseEntity<T>>(future){

            protected T adapt(ResponseEntity<T> result) throws ExecutionException {
                return result.getBody();
            }
        };
    }
}

