/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.ORemoteConnectionManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteThread;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OEngineRemote
extends OEngineAbstract {
    public static final String NAME = "remote";
    protected static final Map<String, OStorageRemote> sharedStorages = new ConcurrentHashMap<String, OStorageRemote>();
    protected final ORemoteConnectionManager connectionManager = new ORemoteConnectionManager(OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.getValueAsInteger(), OGlobalConfiguration.NETWORK_LOCK_TIMEOUT.getValueAsLong());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage createStorage(String iURL, Map<String, String> iConfiguration) {
        OGlobalConfiguration.SECURITY_MAX_CACHED_ROLES.setValue((Object)0);
        OGlobalConfiguration.SECURITY_MAX_CACHED_USERS.setValue((Object)0);
        try {
            Map<String, OStorageRemote> map = sharedStorages;
            synchronized (map) {
                OStorageRemote sharedStorage = sharedStorages.get(iURL);
                if (sharedStorage == null) {
                    sharedStorage = new OStorageRemote(null, iURL, "rw");
                    sharedStorages.put(iURL, sharedStorage);
                }
                return new OStorageRemoteThread(sharedStorage);
            }
        }
        catch (Throwable t) {
            OLogManager.instance().error((Object)this, "Error on opening database: " + iURL, t, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorage(String iURL) {
        Map<String, OStorageRemote> map = sharedStorages;
        synchronized (map) {
            sharedStorages.remove(iURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorage(OStorage iStorage) {
        Map<String, OStorageRemote> map = sharedStorages;
        synchronized (map) {
            for (Map.Entry<String, OStorageRemote> entry : sharedStorages.entrySet()) {
                if (entry.getValue() != iStorage) continue;
                sharedStorages.remove(entry.getKey());
                break;
            }
        }
    }

    public void shutdown() {
        super.shutdown();
        this.connectionManager.close();
        sharedStorages.clear();
    }

    public ORemoteConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public String getName() {
        return NAME;
    }

    public boolean isShared() {
        return false;
    }
}

