/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLCreateVertex
extends OCommandExecutorSQLSetAware
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "CREATE VERTEX";
    private OClass clazz;
    private String clusterName;
    private List<OPair<String, Object>> fields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLCreateVertex parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLCreateVertex.getDatabase();
            this.init((OCommandRequestText)iRequest);
            String className = null;
            this.parserRequiredKeyword(new String[]{"CREATE"});
            this.parserRequiredKeyword(new String[]{"VERTEX"});
            String temp = this.parseOptionalWord(true, new String[0]);
            while (temp != null) {
                if (temp.equals("CLUSTER")) {
                    this.clusterName = this.parserRequiredWord(false);
                } else if (temp.equals("SET")) {
                    this.fields = new ArrayList<OPair<String, Object>>();
                    this.parseSetFields(this.clazz, this.fields);
                } else if (temp.equals("CONTENT")) {
                    this.parseContent();
                } else if (className == null && temp.length() > 0) {
                    className = temp;
                    if (className == null) {
                        className = "V";
                    }
                    this.clazz = ((OMetadataInternal)database.getMetadata()).getImmutableSchemaSnapshot().getClass(className);
                    if (this.clazz == null) {
                        throw new OCommandSQLParsingException("Class '" + className + "' was not found");
                    }
                }
                temp = this.parserOptionalWord(true);
                if (!this.parserIsEnded()) continue;
            }
            if (className == null) {
                className = "V";
                this.clazz = ((OMetadataInternal)database.getMetadata()).getImmutableSchemaSnapshot().getClass(className);
                if (this.clazz == null) {
                    throw new OCommandSQLParsingException("Class '" + className + "' was not found");
                }
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    public Object execute(final Map<Object, Object> iArgs) {
        if (this.clazz == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        return OGraphCommandExecutorSQLFactory.runWithAnyGraph(new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

            @Override
            public Object call(OrientBaseGraph graph) {
                OrientVertex vertex = graph.addTemporaryVertex(OCommandExecutorSQLCreateVertex.this.clazz.getName(), new Object[0]);
                if (OCommandExecutorSQLCreateVertex.this.fields != null) {
                    for (OPair f : OCommandExecutorSQLCreateVertex.this.fields) {
                        if (!(f.getValue() instanceof OSQLFunctionRuntime)) continue;
                        f.setValue(((OSQLFunctionRuntime)f.getValue()).getValue((OIdentifiable)vertex.getRecord(), null, OCommandExecutorSQLCreateVertex.this.context));
                    }
                }
                OSQLHelper.bindParameters((ODocument)vertex.getRecord(), (List)OCommandExecutorSQLCreateVertex.this.fields, (OCommandParameters)new OCommandParameters(iArgs), (OCommandContext)OCommandExecutorSQLCreateVertex.this.context);
                if (OCommandExecutorSQLCreateVertex.this.content != null) {
                    vertex.getRecord().merge(OCommandExecutorSQLCreateVertex.this.content, true, false);
                }
                if (OCommandExecutorSQLCreateVertex.this.clusterName != null) {
                    vertex.save(OCommandExecutorSQLCreateVertex.this.clusterName);
                } else {
                    vertex.save();
                }
                return vertex.getRecord();
            }
        });
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public Set<String> getInvolvedClusters() {
        if (this.clazz != null) {
            return Collections.singleton(OCommandExecutorSQLCreateVertex.getDatabase().getClusterNameById(this.clazz.getClusterSelection().getCluster(this.clazz, null)));
        }
        if (this.clusterName != null) {
            return this.getInvolvedClustersOfClusters(Collections.singleton(this.clusterName));
        }
        return Collections.EMPTY_SET;
    }

    public String getSyntax() {
        return "CREATE VERTEX [<class>] [CLUSTER <cluster>] [SET <field> = <expression>[,]*]";
    }
}

