/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class OHttpGraphResponse
extends OHttpResponse {
    public OHttpGraphResponse(OHttpResponse iWrapped) {
        super(iWrapped.getOutputStream(), iWrapped.httpVersion, iWrapped.additionalHeaders, iWrapped.characterSet, iWrapped.serverInfo, iWrapped.sessionId, iWrapped.callbackFunction, iWrapped.keepAlive, iWrapped.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept, Map<String, Object> iAdditionalProperties, String mode) throws IOException {
        if (iRecords == null) {
            return;
        }
        if (!mode.equalsIgnoreCase("graph")) {
            super.writeRecords(iRecords, iFetchPlan, iFormat, accept, iAdditionalProperties, mode);
            return;
        }
        if (accept != null && accept.contains("text/csv")) {
            throw new IllegalArgumentException("Graph mode cannot accept '" + accept + "'");
        }
        OrientGraphNoTx graph = (OrientGraphNoTx)OrientGraphFactory.getNoTxGraphImplFactory().getGraph((ODatabaseDocumentTx)ODatabaseRecordThreadLocal.INSTANCE.get());
        try {
            Object v;
            HashSet<OrientVertex> vertices = new HashSet<OrientVertex>();
            HashSet<OrientEdge> edges = new HashSet<OrientEdge>();
            Iterator iIterator = OMultiValue.getMultiValueIterator((Object)iRecords);
            while (iIterator.hasNext()) {
                Object entry = iIterator.next();
                if (entry == null || !(entry instanceof OIdentifiable) || (entry = ((OIdentifiable)entry).getRecord()) == null || !(entry instanceof OIdentifiable) || !(entry instanceof ODocument)) continue;
                OClass schemaClass = ((ODocument)entry).getSchemaClass();
                if (schemaClass != null && schemaClass.isVertexType()) {
                    vertices.add(graph.getVertex(entry));
                    continue;
                }
                if (schemaClass == null || !schemaClass.isEdgeType()) continue;
                OrientEdge edge = graph.getEdge(entry);
                vertices.add(graph.getVertex(edge.getVertex(Direction.IN)));
                vertices.add(graph.getVertex(edge.getVertex(Direction.OUT)));
                edges.add(edge);
            }
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter((Writer)buffer, "");
            json.beginObject();
            json.beginObject((Object)"graph");
            json.beginCollection("vertices");
            for (OrientVertex orientVertex : vertices) {
                json.beginObject();
                json.writeAttribute("@rid", (Object)orientVertex.getIdentity());
                json.writeAttribute("@class", (Object)orientVertex.getRecord().getClassName());
                for (Edge e : orientVertex.getEdges(Direction.BOTH, new String[0])) {
                    edges.add((OrientEdge)e);
                }
                for (String field : orientVertex.getPropertyKeys()) {
                    v = orientVertex.getProperty(field);
                    if (v == null) continue;
                    json.writeAttribute(field, v);
                }
                json.endObject();
            }
            json.endCollection();
            json.beginCollection("edges");
            for (OrientEdge orientEdge : edges) {
                if (!vertices.contains(orientEdge.getVertex(Direction.OUT)) || !vertices.contains(orientEdge.getVertex(Direction.IN))) continue;
                json.beginObject();
                json.writeAttribute("@rid", (Object)orientEdge.getIdentity());
                json.writeAttribute("@class", (Object)orientEdge.getRecord().getClassName());
                json.writeAttribute("out", orientEdge.getVertex(Direction.OUT).getId());
                json.writeAttribute("in", orientEdge.getVertex(Direction.IN).getId());
                for (String field : orientEdge.getPropertyKeys()) {
                    v = orientEdge.getProperty(field);
                    if (v == null) continue;
                    json.writeAttribute(field, v);
                }
                json.endObject();
            }
            json.endCollection();
            if (iAdditionalProperties != null) {
                for (Map.Entry entry : iAdditionalProperties.entrySet()) {
                    Object v2 = entry.getValue();
                    if (OMultiValue.isMultiValue(v2)) {
                        json.beginCollection(-1, true, (String)entry.getKey());
                        this.formatMultiValue(OMultiValue.getMultiValueIterator(v2), buffer, null);
                        json.endCollection(-1, true);
                    } else {
                        json.writeAttribute((String)entry.getKey(), v2);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
            }
            json.endObject();
            json.endObject();
            this.send(200, "OK", "application/json", buffer.toString(), null);
        }
        finally {
            graph.shutdown();
        }
    }
}

