/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OrientClassVertexIterator
implements Iterator<Vertex> {
    private Iterator<Vertex> iterator;
    private OClass klass;
    private OrientVertex vertex;
    private OrientBaseGraph graph;

    public OrientClassVertexIterator(OrientBaseGraph graph, Iterator<Vertex> iterator, String klass) {
        this.iterator = iterator;
        this.graph = graph;
        this.klass = graph.getRawGraph().getMetadata().getSchema().getClass(klass);
    }

    @Override
    public boolean hasNext() {
        if (this.vertex == null) {
            while (this.iterator.hasNext()) {
                this.vertex = (OrientVertex)this.iterator.next();
                if (this.vertex == null || !this.klass.isSuperClassOf(this.vertex.getRecord().getSchemaClass())) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public Vertex next() {
        if (this.vertex == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        OrientVertex cur = this.vertex;
        this.vertex = null;
        return cur;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

