/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryInputStream;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.protocol.binary.OBinaryNetworkProtocolAbstract;
import com.orientechnologies.orient.server.network.protocol.distributed.OReplicationActiveThreadLocal;
import com.orientechnologies.orient.server.replication.ODistributedDatabaseInfo;
import com.orientechnologies.orient.server.replication.conflict.OReplicationConflictException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class OClusterNetworkProtocol
extends OBinaryNetworkProtocolAbstract
implements OCommandOutputListener {
    private ODistributedServerManager manager;
    private String remoteNodeId;
    private String commandInfo;
    private final Map<String, ODatabaseRecord> databases = new HashMap<String, ODatabaseRecord>(5);
    private final OClusterLogger logger = new OClusterLogger();

    public OClusterNetworkProtocol() {
        super("OrientDB <- Node/?");
        this.manager = OServerMain.server().getHandler(ODistributedServerManager.class);
        if (this.manager == null) {
            throw new OConfigurationException("Cannot find a ODistributedServerDiscoveryManager instance registered as handler. Check the server configuration in the handlers section.");
        }
    }

    @Override
    public void config(OServer iServer, Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super.config(iServer, iSocket, iConfig);
        this.channel.writeShort((short)0);
        this.channel.flush();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected boolean executeRequest() throws IOException {
        switch (this.requestType) {
            case 100: {
                this.commandInfo = "Connection from node";
                this.remoteNodeId = this.channel.readString();
                this.logger.setNode(this.remoteNodeId);
                this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "connected, authenticating it...", new Object[0]);
                this.setName("OrientDB <- Node/" + this.remoteNodeId);
                userName = this.channel.readString();
                this.serverUser = OServerMain.server().serverLogin(userName, this.channel.readString(), "connect");
                this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "authenticated correctly with user '%s'", new Object[]{userName});
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    break;
                }
                finally {
                    this.endResponse();
                }
            }
            case 101: {
                this.commandInfo = "Connection from leader";
                doc = new ODocument().fromStream(this.channel.readBytes());
                clusterName = (String)doc.field("clusterName");
                encodedSecurityKey = (byte[])doc.field("clusterKey");
                leaderAddress = (String)doc.field("leaderNodeAddress");
                this.logger.setNode(leaderAddress);
                if (!clusterName.equals(this.manager.getName()) || !Arrays.equals(encodedSecurityKey, this.manager.getConfig().getSecurityKey())) {
                    throw new OSecurityException("Invalid combination of cluster name and key received");
                }
                remainTheLeader = false;
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    if (this.manager.isLeader()) {
                        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "received remote connection from the leader, but current node is itself leader: split network problem or high network latency?", new Object[0]);
                        myUid = InetAddress.getLocalHost().getHostAddress() + ":" + this.channel.socket.getLocalPort();
                        if (leaderAddress.compareTo(myUid) > 0) {
                            remainTheLeader = true;
                            this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "current node remains the Leader of the cluster because it has lower network address", new Object[0]);
                        }
                    }
                    this.channel.writeByte((byte)(remainTheLeader == false));
                    if (!remainTheLeader) {
                        localCfg = this.manager.getReplicator().getLocalDatabaseConfiguration();
                        this.channel.writeBytes(localCfg.toStream());
                    }
                }
                finally {
                    this.endResponse();
                }
                if (remainTheLeader) {
                    this.sendShutdown();
                    break;
                }
                this.setName("OrientDB <- Distributed Leader");
                this.manager.becomePeer(this);
                this.manager.getReplicator().updateConfiguration(new ODocument(this.channel.readBytes()));
                break;
            }
            case 102: {
                this.checkConnected();
                this.commandInfo = "Cluster Heartbeat";
                lastInterval = this.manager.updateHeartBeatTime();
                this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "heartbeat. Last msg was %dms ago", new Object[]{lastInterval});
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    break;
                }
                finally {
                    this.endResponse();
                }
            }
            case 104: {
                this.commandInfo = "Synchronization between nodes";
                dbName = this.channel.readString();
                cfg = new ODocument(this.channel.readBytes());
                this.logger.setDatabase(dbName);
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "received synchronization request", new Object[0]);
                db = this.getOrOpenDatabase(dbName);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                }
                finally {
                    this.endResponse();
                }
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "opening a connection back...", new Object[0]);
                this.manager.getReplicator().connect(this.remoteNodeId, dbName, ODistributedDatabaseInfo.SYNCH_TYPE.ASYNCH.toString());
                replicationNode = this.manager.getReplicator().getNode(this.remoteNodeId);
                this.manager.getReplicator().getConflictResolver().init((ODatabaseComplex<?>)db);
                op = new ORecordOperation();
                nodes = (Collection)cfg.field("nodes");
                sent = 0;
                for (ODocument nodeCfg : nodes) {
                    node = (String)nodeCfg.field("node");
                    lastLog = (Long)nodeCfg.field("lastLog");
                    this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "reading operation for node %s logs after %d", new Object[]{node, lastLog});
                    opLog = this.manager.getReplicator().getOperationLog(node, dbName);
                    if (opLog == null || (position = opLog.findOperationId(lastLog)) <= -1) continue;
                    totalToSend = opLog.totalEntries();
                    for (i = position; i < totalToSend; ++i) {
                        opLog.getEntry(i, op);
                        try {
                            replicationNode.propagateChange(op, ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH, false);
                            this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "#%d operation %d with RID %s", new Object[]{++sent, op.serial, op.record.getIdentity()});
                            continue;
                        }
                        catch (OSerializationException e) {
                            this.logger.log((Object)this, Level.SEVERE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "#%d cannot be transmitted, log entry %d, record %s: ", new Object[]{sent, op.serial, op.record.getIdentity(), e.getCause()});
                            continue;
                        }
                        catch (RuntimeException e) {
                            this.logger.log((Object)this, Level.SEVERE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "#%d cannot be transmitted, log entry %d, record %s", e, new Object[]{sent, op.serial, op.record.getIdentity()});
                            throw e;
                        }
                    }
                }
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "starting inverse replication...", new Object[0]);
                this.manager.getReplicator().startReplication(this.remoteNodeId, dbName, ODistributedDatabaseInfo.SYNCH_TYPE.ASYNCH.toString());
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "synchronization completed", new Object[0]);
                break;
            }
            case 107: {
                this.commandInfo = "Alignment between nodes";
                cfg = new ODocument(this.channel.readBytes());
                dbName = (String)cfg.field("db");
                block = (ODocument)cfg.field("block");
                this.logger.setDatabase(dbName);
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "received alignment request", new Object[0]);
                db = this.getOrOpenDatabase(dbName);
                storage = db.getStorage();
                remoteNode = this.manager.getReplicator().getNode(this.remoteNodeId);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                }
                finally {
                    this.endResponse();
                }
                rid = new ORecordId();
                for (String ridAsString : block.fieldNames()) {
                    rid.fromString(ridAsString.replace('_', ':'));
                    localRecord = storage.readRecord(rid, null, false, null);
                    remoteVersion = (Integer)block.field(ridAsString);
                    if (localRecord.version == -1) {
                        if (remoteVersion <= -1) continue;
                        remoteNode.propagateChange(new ORecordOperation((OIdentifiable)rid, 2), ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH, false);
                        continue;
                    }
                    if (remoteVersion == -1) {
                        if (localRecord.version <= -1) continue;
                        db.delete((ORID)rid);
                        continue;
                    }
                    if (localRecord.version > remoteVersion) {
                        this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "Sending record %s to remote: my version %d > remote %d", new Object[]{rid, localRecord.version, remoteVersion});
                        remoteNode.propagateChange(new ORecordOperation((OIdentifiable)rid, 1), ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH, false);
                        continue;
                    }
                    if (localRecord.version >= remoteVersion) continue;
                    this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "Getting remote record %s: its version %d > mine %d", new Object[]{rid, remoteVersion, localRecord.version});
                    remoteNode.requestRecord(dbName, rid);
                }
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "alignment completed for %d", new Object[]{block.fields()});
                break;
            }
            case 106: {
                this.commandInfo = "Retrieve record";
                dbName = this.channel.readString();
                rid = this.channel.readRID();
                this.logger.setNode(dbName);
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "record %s...", new Object[]{rid});
                database = this.getOrOpenDatabase(dbName);
                record = (ORecordInternal)database.load((ORID)rid);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    if (record != null) {
                        this.channel.writeByte(record.getRecordType());
                        this.channel.writeInt(record.getVersion());
                        this.channel.writeBytes(record.toStream());
                        break;
                    }
                    this.channel.writeByte((byte)-1);
                    break;
                }
                finally {
                    this.endResponse();
                }
            }
            case 105: {
                this.commandInfo = "Distributed record change";
                dbName = this.channel.readString();
                operationType = this.channel.readByte();
                operationId = this.channel.readLong();
                rid = this.channel.readRID();
                buffer = this.channel.readBytes();
                version = this.channel.readInt() - 1;
                recordType = this.channel.readByte();
                this.logger.setNode(dbName);
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "%s record %s...", new Object[]{ORecordOperation.getName((int)operationType), rid});
                database = this.getOrOpenDatabase(dbName);
                OReplicationActiveThreadLocal.INSTANCE.set(false);
                try {
                    switch (operationType) {
                        case 3: {
                            origClusterPosition = rid.clusterPosition;
                            rid.clusterPosition = -1L;
                            result = this.createRecord(database, rid, buffer, recordType, 0).getIdentity().getClusterPosition();
                            if (result != origClusterPosition) {
                                throw new OReplicationConflictException("Remote record has RID different by the original", (ORID)rid, (ORID)new ORecordId(rid.clusterId, result));
                            }
                            rid.clusterPosition = result;
                            ** break;
lbl209:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            result = this.updateRecord(database, rid, buffer, version, recordType);
                            ** break;
lbl213:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            result = this.deleteRecord(database, (ORID)rid, version);
                            ** break;
lbl217:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Received invalid distributed record change operation type: " + operationType);
                        }
                    }
                }
                finally {
                    OReplicationActiveThreadLocal.INSTANCE.set(true);
                }
                node = this.manager.getReplicator().getNode(this.remoteNodeId);
                db = node.getDatabase(database.getName());
                db.getLog().appendLog(operationId, operationType, rid);
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    this.channel.writeLong(result);
                    break;
                }
                finally {
                    this.endResponse();
                }
            }
            case 103: {
                this.checkConnected();
                this.commandInfo = "Importing a database from a remote node";
                dbName = this.channel.readString();
                dbUser = this.channel.readString();
                dbPasswd = this.channel.readString();
                dbType = this.channel.readString();
                engineType = this.channel.readString();
                try {
                    this.logger.setNode(dbName);
                    this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "importing database...", new Object[0]);
                    database = this.getDatabaseInstance(dbName, dbType, engineType);
                    if (database.exists()) {
                        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "deleting existent database...", new Object[]{database.getName()});
                        database.drop();
                        this.manager.getReplicator().resetAnyPreviousReplicationLog(dbName);
                    }
                    if ((database = this.createDatabase(database, dbUser, dbPasswd)).isClosed()) {
                        database.open(dbUser, dbPasswd);
                    }
                    this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "reading database content via streaming from remote server node...", new Object[0]);
                    this.beginResponse();
                    try {
                        OReplicationActiveThreadLocal.INSTANCE.set(false);
                        new ODatabaseImport((ODatabaseDocument)database, (InputStream)new OChannelBinaryInputStream((OChannelBinary)this.channel), (OCommandOutputListener)this).importDatabase();
                        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "database imported correctly", new Object[0]);
                        this.sendOk(this.clientTxId);
                    }
                    finally {
                        OReplicationActiveThreadLocal.INSTANCE.set(true);
                        this.endResponse();
                    }
                }
                finally {
                    this.manager.getPeer().updateHeartBeatTime();
                }
                this.manager.getPeer().updateConfigurationToLeader();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected ODatabaseRecord getOrOpenDatabase(String dbName) {
        ODatabaseRecord db = this.databases.get(dbName);
        if (db == null) {
            db = (ODatabaseDocumentTx)OServerMain.server().openDatabase("document", dbName, this.serverUser.name, this.serverUser.password);
            this.databases.put(dbName, db);
        }
        ODatabaseRecordThreadLocal.INSTANCE.set((Object)db);
        return db;
    }

    private void beginResponse() {
        this.channel.acquireExclusiveLock();
    }

    private void endResponse() throws IOException {
        this.channel.flush();
        this.channel.releaseExclusiveLock();
    }

    public void onMessage(String iText) {
    }

    @Override
    public String getType() {
        return "cluster";
    }

    protected void checkConnected() {
    }
}

