/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.thread.OPollerThread;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.security.Key;
import java.util.TimerTask;
import java.util.logging.Level;

public class ODiscoverySignaler
extends OPollerThread {
    private byte[] discoveryPacket;
    private DatagramPacket dgram;
    private DatagramSocket socket;
    private ODistributedServerManager manager;
    private TimerTask runningTask;
    private OClusterLogger logger = new OClusterLogger();

    public ODiscoverySignaler(ODistributedServerManager iManager, OServerNetworkListener iNetworkListener) {
        super((long)(iManager.getConfig().networkMulticastHeartbeat * 1000), Orient.getThreadGroup(), "OrientDB Distributed-DiscoverySignaler");
        this.manager = iManager;
        String buffer = "OrientDB v.1.0.1|1|" + this.manager.getConfig().name + "|" + iNetworkListener.getInboundAddr().getHostName() + "|" + iNetworkListener.getInboundAddr().getPort();
        this.discoveryPacket = OSecurityManager.instance().encrypt(this.manager.getConfig().securityAlgorithm, (Key)this.manager.getConfig().securityKey, buffer.getBytes());
        this.start();
        this.startTimeoutPresenceTask();
    }

    private void startTimeoutPresenceTask() {
        if (this.runningTask != null) {
            return;
        }
        this.runningTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (ODiscoverySignaler.this.isRunning() && !ODiscoverySignaler.this.manager.isLeader()) {
                        ODiscoverySignaler.this.manager.becameLeader();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Orient.getTimer().schedule(this.runningTask, this.manager.getConfig().networkTimeoutLeader);
    }

    public void startup() {
        try {
            this.dgram = new DatagramPacket(this.discoveryPacket, this.discoveryPacket.length, this.manager.getConfig().networkMulticastAddress, this.manager.getConfig().networkMulticastPort);
            this.socket = new DatagramSocket();
            this.logger.setNode(this.manager.getConfig().networkMulticastAddress + ":" + this.manager.getConfig().networkMulticastPort);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "LEADER Cannot startup distributed server discovery signaler", (Throwable)e, new Object[0]);
        }
        super.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        if (this.dgram == null) {
            this.sendShutdown();
            return;
        }
        this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.OUT, "network ip multicast...", new Object[0]);
        try {
            this.socket.send(this.dgram);
        }
        catch (Throwable t) {
            this.sendShutdown();
            this.logger.log((Object)this, Level.SEVERE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.OUT, "Error on sending signal for distributed server presence, probably the IP MULTICAST is disabled in current network configuration: %s", t.getMessage());
        }
    }

    public void shutdown() {
        super.shutdown();
        if (this.runningTask != null) {
            this.runningTask.cancel();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = null;
        this.dgram = null;
    }
}

