/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering.leader;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.security.Key;
import java.util.logging.Level;

public class ODiscoveryListener
extends OSoftThread {
    private final byte[] recvBuffer = new byte[50000];
    private DatagramPacket dgram;
    private ODistributedServerManager manager;
    private OServerNetworkListener binaryNetworkListener;
    private MulticastSocket socket;
    private OClusterLogger logger = new OClusterLogger();

    public ODiscoveryListener(ODistributedServerManager iManager, OServerNetworkListener iNetworkListener) {
        super(Orient.getThreadGroup(), "OrientDB Distributed-DiscoveryListener");
        this.manager = iManager;
        this.binaryNetworkListener = iNetworkListener;
        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "listening for distributed nodes on IP multicast: %s:%d", iManager.getConfig().networkMulticastAddress, iManager.getConfig().networkMulticastPort);
        this.dgram = new DatagramPacket(this.recvBuffer, this.recvBuffer.length);
        try {
            this.socket = new MulticastSocket(iManager.getConfig().networkMulticastPort);
            this.socket.joinGroup(iManager.getConfig().networkMulticastAddress);
        }
        catch (IOException e) {
            throw new OIOException("Cannot startup the Discovery Listener service to catch distributed server nodes, probably the IP MULTICAST is disabled in current network configuration: " + e.getMessage());
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        try {
            this.dgram.setLength(this.recvBuffer.length);
            this.socket.receive(this.dgram);
            this.logger.setNode(this.dgram.getAddress() + ":" + this.dgram.getPort());
            this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "received multicast packet %d bytes from", this.dgram.getLength());
            byte[] buffer = new byte[this.dgram.getLength()];
            System.arraycopy(this.dgram.getData(), 0, buffer, 0, buffer.length);
            try {
                String packet = new String(OSecurityManager.instance().decrypt(this.manager.getConfig().securityAlgorithm, (Key)this.manager.getConfig().securityKey, buffer));
                String[] parts = packet.trim().split("\\|");
                int i = 0;
                if (!parts[i].startsWith("OrientDB v.")) {
                    this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "packet discarded because invalid", new Object[0]);
                    return;
                }
                if (Integer.parseInt(parts[++i]) != 1) {
                    this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "received bad multicast packet with version %s not equals to the current %d", parts[i], 1);
                    return;
                }
                if (!parts[++i].equals(this.manager.getConfig().name)) {
                    this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "received bad multicast packet with cluster name %s not equals to the current %s", parts[i], this.manager.getConfig().name);
                    return;
                }
                String configuredServerAddress = parts[++i];
                String sourceServerAddress = this.dgram.getAddress().getHostAddress();
                int serverPort = Integer.parseInt(parts[++i]);
                if (configuredServerAddress.equals(this.binaryNetworkListener.getInboundAddr().getHostName()) && serverPort == this.binaryNetworkListener.getInboundAddr().getPort()) {
                    this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "ignored because sent by myself", new Object[0]);
                    return;
                }
                if (this.manager.getLeader() == null) {
                    this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "packet discarded because I'm not the leader", new Object[0]);
                    return;
                }
                this.manager.getLeader().connect2Peer(new String[]{sourceServerAddress, configuredServerAddress}, serverPort);
            }
            catch (Exception e) {
                this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "received wrong packet from multicast IP", e, new Object[0]);
            }
        }
        catch (Throwable t) {
            this.logger.error((Object)this, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "Error on executing request", t, null, new Object[0]);
        }
    }
}

