/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering.leader;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.clustering.leader.ODiscoveryListener;
import com.orientechnologies.orient.server.clustering.leader.OPeerCheckerTask;
import com.orientechnologies.orient.server.clustering.leader.ORemotePeer;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;

public class OLeaderNode {
    private ODistributedServerManager manager;
    private final HashMap<String, ORemotePeer> nodes = new LinkedHashMap<String, ORemotePeer>();
    private ODocument clusterDbConfigurations = new ODocument();
    private ODiscoveryListener discoveryListener;
    private OClusterLogger logger = new OClusterLogger();
    private OPeerCheckerTask peerCheckerTask;

    public OLeaderNode(ODistributedServerManager iManager) {
        this.manager = iManager;
        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "current node is the new Leader Node of cluster '%s'", iManager.getConfig().name);
        for (String db : OServerMain.server().getAvailableStorageNames().keySet()) {
            try {
                this.addServerInConfiguration(db, this.manager.getId(), "synch");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        this.discoveryListener = new ODiscoveryListener(this.manager, this.manager.getDistributedNetworkListener());
        this.peerCheckerTask = new OPeerCheckerTask(this);
        Orient.getTimer().schedule((TimerTask)this.peerCheckerTask, this.manager.getConfig().networkHeartbeatDelay, (long)this.manager.getConfig().networkHeartbeatDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        OLeaderNode oLeaderNode = this;
        synchronized (oLeaderNode) {
            for (Map.Entry<String, ORemotePeer> node : this.nodes.entrySet()) {
                node.getValue().disconnect();
            }
            this.nodes.clear();
            this.clusterDbConfigurations.clear();
            if (this.peerCheckerTask != null) {
                this.peerCheckerTask.cancel();
                this.peerCheckerTask = null;
            }
            if (this.discoveryListener != null) {
                this.discoveryListener.sendShutdown();
                this.discoveryListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect2Peer(String[] iServerAddresses, int iServerPort) {
        Exception lastException = null;
        if (OLogManager.instance().isDebugEnabled()) {
            this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "trying to connecting to peer %s:%d", Arrays.toString(iServerAddresses), iServerPort);
        }
        for (String serverAddress : iServerAddresses) {
            String key = ODistributedServerManager.getNodeName(serverAddress, iServerPort);
            OLeaderNode oLeaderNode = this;
            synchronized (oLeaderNode) {
                ORemotePeer node;
                if (this.nodes.containsKey(key)) {
                    node = this.nodes.get(key);
                    this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "peer %s already registered. Now has status: %s", new Object[]{key, node.getStatus()});
                    if (node.getStatus() != ORemotePeer.STATUS.UNREACHABLE && node.getStatus() != ORemotePeer.STATUS.DISCONNECTED && node.checkConnection()) {
                        return;
                    }
                } else {
                    node = new ORemotePeer(this, serverAddress, iServerPort);
                }
                try {
                    if (node.connect(this.manager.getConfig().networkTimeoutNode, this.manager.getConfig().name, this.manager.getConfig().securityKey)) {
                        this.nodes.put(key, node);
                    }
                    return;
                }
                catch (Exception e) {
                    lastException = e;
                }
            }
        }
        if (iServerAddresses.length > 1) {
            this.logger.error(this, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "cannot connect to distributed server node using addresses %s:%d and %s:%d", lastException, null, iServerAddresses[0], iServerPort, iServerAddresses[1], iServerPort);
        } else {
            this.logger.error(this, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "cannot connect to distributed server node using addresses %s:%d", lastException, null, iServerAddresses[0], iServerPort);
        }
    }

    public void handlePeerNodeFailure(ORemotePeer iNode) {
        iNode.disconnect();
        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "peer node %s seems down, retrying to connect...", iNode.getId());
        try {
            if (iNode.connect(this.manager.getConfig().networkTimeoutNode, this.manager.getConfig().name, this.manager.getConfig().securityKey)) {
                return;
            }
        }
        catch (IOException e) {
            this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "remote server node %s is down, set it as DISCONNECTED and start to buffer changes", iNode.getId());
        }
        this.removePeer(iNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORemotePeer getPeerNode(String iName) {
        OLeaderNode oLeaderNode = this;
        synchronized (oLeaderNode) {
            return this.nodes.get(iName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ORemotePeer> getPeerNodeList() {
        OLeaderNode oLeaderNode = this;
        synchronized (oLeaderNode) {
            if (this.nodes.isEmpty()) {
                return null;
            }
            return new ArrayList<ORemotePeer>(this.nodes.values());
        }
    }

    public ODocument updatePeerDatabases(String iNodeId, ODocument iConfiguration) throws UnknownHostException {
        if (iConfiguration == null) {
            return null;
        }
        ODocument answer = new ODocument();
        for (String dbName : iConfiguration.fieldNames()) {
            this.manager.getLeader().addServerInConfiguration(dbName, iNodeId, "synch");
            answer.field(dbName, (Object)this.manager.getLeader().getClusteredConfigurationForDatabase(dbName));
        }
        return answer;
    }

    public List<ODocument> getPeerNodesOwnDatabase(String iDatabaseName) {
        ODocument doc = (ODocument)this.clusterDbConfigurations.field(iDatabaseName);
        return (List)(doc != null ? doc.field("nodes") : null);
    }

    public ODocument getClusteredConfigurationForDatabase(String iDatabaseName) {
        return (ODocument)this.clusterDbConfigurations.field(iDatabaseName);
    }

    public ODocument getClusteredConfiguration() {
        return this.clusterDbConfigurations;
    }

    public ODocument addServerInConfiguration(String iDatabaseName, String iNodeId, String iReplicationMode) throws UnknownHostException {
        List nodeList;
        ODocument dbConfiguration = (ODocument)this.clusterDbConfigurations.field(iDatabaseName);
        if (dbConfiguration == null) {
            dbConfiguration = new ODocument().addOwner((ORecordElement)this.clusterDbConfigurations);
            nodeList = new ORecordLazyList(dbConfiguration);
            dbConfiguration.field("nodes", (Object)nodeList);
            this.clusterDbConfigurations.field(iDatabaseName, (Object)dbConfiguration);
        } else {
            nodeList = (List)dbConfiguration.field("nodes");
            for (OIdentifiable d : nodeList) {
                if (!((ODocument)d).field("id").equals(iNodeId)) continue;
                return (ODocument)d;
            }
        }
        ODocument node = new ODocument().addOwner((ORecordElement)dbConfiguration);
        nodeList.add(node);
        node.field("id", (Object)iNodeId);
        node.field("mode", (Object)iReplicationMode);
        this.manager.sendClusterConfigurationToClients(iDatabaseName, this.getClusteredConfigurationForDatabase(iDatabaseName));
        return node;
    }

    public ODistributedServerManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(ORemotePeer iNode) {
        OLeaderNode oLeaderNode = this;
        synchronized (oLeaderNode) {
            this.nodes.remove(iNode.getId());
            block3: for (Object cfg : this.clusterDbConfigurations.fieldValues()) {
                List servers = (List)((ODocument)cfg).field("nodes");
                for (ODocument server : servers) {
                    if (!server.field("id").equals(iNode.getId())) continue;
                    servers.remove(server);
                    continue block3;
                }
            }
        }
        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "removed server node %s", iNode.getId());
    }
}

