/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering.leader;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OAsynchChannelServiceThread;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import java.io.IOException;
import java.util.Date;

public abstract class ORemoteNodeAbstract {
    protected String id;
    protected String networkAddress;
    protected int networkPort;
    protected Date connectedOn;
    protected OChannelBinaryClient channel;
    protected final int sessionId = 0;
    protected OAsynchChannelServiceThread serviceThread;
    protected OClusterLogger logger = new OClusterLogger();
    protected final int timeout;

    public ORemoteNodeAbstract(String iServerAddress, int iServerPort) {
        this.networkAddress = iServerAddress;
        this.networkPort = iServerPort;
        this.connectedOn = new Date();
        this.id = this.networkAddress + ":" + this.networkPort;
        this.timeout = OGlobalConfiguration.DISTRIBUTED_SOCKET_TIMEOUT.getValueAsInteger();
    }

    protected abstract void connect() throws IOException;

    public OChannelBinaryClient beginRequest(byte iRequestType) throws IOException {
        if (!this.checkConnection()) {
            this.connect();
        }
        this.channel.beginRequest();
        this.channel.writeByte(iRequestType);
        this.channel.writeInt(0);
        return this.channel;
    }

    public void endRequest() throws IOException {
        if (this.channel != null) {
            this.channel.endRequest();
        }
    }

    public void parseResponse() throws IOException {
        if (this.channel != null) {
            this.channel.beginResponse(0);
            this.channel.endResponse();
        }
    }

    public void beginResponse() throws IOException {
        if (this.channel != null) {
            this.channel.beginResponse(0, (long)this.timeout);
        }
    }

    public void endResponse() {
        if (this.channel != null) {
            this.channel.endResponse();
        }
    }

    public boolean checkConnection() {
        boolean connected = false;
        if (this.channel != null && this.channel.socket != null) {
            try {
                connected = this.channel.socket.isConnected();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return connected;
    }

    public void disconnect() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
        if (this.serviceThread != null) {
            this.serviceThread.sendShutdown();
        }
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }
}

