/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.clustering.peer;

import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.clustering.peer.OPeerNode;
import java.util.TimerTask;
import java.util.logging.Level;

public class OLeaderCheckerTask
extends TimerTask {
    private OPeerNode peer;
    private long heartBeatDelay;
    private OClusterLogger logger = new OClusterLogger();

    public OLeaderCheckerTask(OPeerNode iPeerNode) {
        this.peer = iPeerNode;
        this.heartBeatDelay = this.peer.getManager().getConfig().getNetworkHeartbeatDelay() * 130 / 100;
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis() - this.peer.getLastHeartBeat();
        if (time > this.heartBeatDelay) {
            this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.IN, "no heartbeat message has been received from the Leader node (last was %d ms ago)", time);
            this.cancel();
            this.peer.getManager().becameLeader();
        }
    }
}

