/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.enterprise.command.OCommandExecutorScript;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.handler.OServerHandlerAbstract;

public class OServerSideScriptInterpreter
extends OServerHandlerAbstract {
    private boolean enabled = false;

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        for (OServerParameterConfiguration param : iParams) {
            if (!param.name.equalsIgnoreCase("enabled") || !Boolean.parseBoolean(param.value)) continue;
            this.enabled = true;
        }
    }

    public String getName() {
        return "script-interpreter";
    }

    @Override
    public void startup() {
        if (!this.enabled) {
            return;
        }
        OLogManager.instance().info((Object)this, "Installing Script interpreter. WARN: clients can execute any kind of code into the server.", new Object[0]);
        OCommandManager.instance().registerExecutor(OCommandScript.class, OCommandExecutorScript.class);
    }

    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        OCommandManager.instance().unregisterExecutor(OCommandScript.class);
    }
}

