/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.replication.conflict.ODefaultReplicationConflictResolver;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;

public class ODistributedServerConfiguration {
    public String name;
    public SecretKey securityKey;
    public String securityAlgorithm;
    public InetAddress networkMulticastAddress;
    public int networkMulticastPort;
    public int networkMulticastHeartbeat;
    public int networkTimeoutLeader;
    public int networkTimeoutNode;
    public int networkHeartbeatDelay;
    public int serverUpdateDelay;
    public Map<String, String> replicationConflictResolverConfig;
    public static final String CHECKSUM = "ChEcKsUm1976";
    public static final String PACKET_HEADER = "OrientDB v.";
    public static final int PROTOCOL_VERSION = 1;
    public static final String REPLICATOR_USER = "replicator";

    public ODistributedServerConfiguration(OServer iServer, ODistributedServerManager iManager, OServerParameterConfiguration[] iParams) {
        try {
            this.name = "unknown";
            this.securityKey = null;
            this.networkMulticastAddress = InetAddress.getByName("235.1.1.1");
            this.networkMulticastPort = 2424;
            this.networkMulticastHeartbeat = 5000;
            this.networkTimeoutLeader = 2000;
            this.networkTimeoutNode = 5000;
            this.networkHeartbeatDelay = 5000;
            this.securityAlgorithm = "Blowfish";
            this.serverUpdateDelay = 0;
            byte[] tempSecurityKey = null;
            this.replicationConflictResolverConfig = new HashMap<String, String>();
            this.replicationConflictResolverConfig.put("strategy", ODefaultReplicationConflictResolver.class.getCanonicalName());
            this.replicationConflictResolverConfig.put("ignoreIfSameContent", "true");
            this.replicationConflictResolverConfig.put("ignoreIfMergeOk", "false");
            this.replicationConflictResolverConfig.put("latestAlwaysWin", "false");
            if (iParams != null) {
                for (OServerParameterConfiguration param : iParams) {
                    if (param.name == null) continue;
                    if ("enabled".equalsIgnoreCase(param.name)) {
                        if (Boolean.parseBoolean(param.value)) continue;
                        iManager.status = ODistributedServerManager.STATUS.DISABLED;
                        continue;
                    }
                    if ("name".equalsIgnoreCase(param.name)) {
                        this.name = param.value;
                        continue;
                    }
                    if ("security.algorithm".equalsIgnoreCase(param.name)) {
                        this.securityAlgorithm = param.value;
                        continue;
                    }
                    if ("security.key".equalsIgnoreCase(param.name)) {
                        tempSecurityKey = OBase64Utils.decode((String)param.value);
                        continue;
                    }
                    if ("network.multicast.address".equalsIgnoreCase(param.name)) {
                        this.networkMulticastAddress = InetAddress.getByName(param.value);
                        continue;
                    }
                    if ("network.multicast.port".equalsIgnoreCase(param.name)) {
                        this.networkMulticastPort = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("network.multicast.heartbeat".equalsIgnoreCase(param.name)) {
                        this.networkMulticastHeartbeat = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("network.timeout.leader".equalsIgnoreCase(param.name)) {
                        this.networkTimeoutLeader = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("network.timeout.connection".equalsIgnoreCase(param.name)) {
                        this.networkTimeoutNode = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("network.heartbeat.delay".equalsIgnoreCase(param.name)) {
                        this.networkHeartbeatDelay = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("server.update.delay".equalsIgnoreCase(param.name)) {
                        this.serverUpdateDelay = Integer.parseInt(param.value);
                        continue;
                    }
                    if (!param.name.startsWith("replication.conflictResolver.")) continue;
                    this.replicationConflictResolverConfig.put(param.name.substring("replication.conflictResolver.".length()), param.value);
                }
            }
            if (OServerMain.server().getUser(REPLICATOR_USER) == null) {
                OServerMain.server().addUser(REPLICATOR_USER, null, "connect,database.passthrough");
            }
            if (tempSecurityKey == null) {
                OLogManager.instance().info((Object)this, "Generating Server security key and saving it in configuration...", new Object[0]);
                this.securityKey = OSecurityManager.instance().generateKey(this.securityAlgorithm, 96);
                for (OServerHandlerConfiguration handler : iServer.getConfiguration().handlers) {
                    if (!handler.clazz.equals(iManager.getClass().getName())) continue;
                    handler.parameters = new OServerParameterConfiguration[iParams.length + 1];
                    for (int i = 0; i < iParams.length; ++i) {
                        handler.parameters[i] = iParams[i];
                    }
                    handler.parameters[iParams.length] = new OServerParameterConfiguration("security.key", OBase64Utils.encodeBytes((byte[])this.securityKey.getEncoded()));
                }
                iServer.saveConfiguration();
            } else {
                this.securityKey = OSecurityManager.instance().createKey(this.securityAlgorithm, tempSecurityKey);
            }
        }
        catch (Exception e) {
            throw new OConfigurationException("Cannot configure OrientDB Server as Cluster Node", (Throwable)e);
        }
    }

    public int getServerUpdateDelay() {
        return this.serverUpdateDelay;
    }

    public int getNetworkHeartbeatDelay() {
        return this.networkHeartbeatDelay;
    }

    public String getSecurityAlgorithm() {
        return this.securityAlgorithm;
    }

    public byte[] getSecurityKey() {
        return this.securityKey.getEncoded();
    }
}

