/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.clustering.OClusterNetworkProtocol;
import com.orientechnologies.orient.server.clustering.ODiscoverySignaler;
import com.orientechnologies.orient.server.clustering.leader.ODiscoveryListener;
import com.orientechnologies.orient.server.clustering.leader.OLeaderNode;
import com.orientechnologies.orient.server.clustering.peer.OPeerNode;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.handler.OServerHandlerAbstract;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerConfiguration;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.replication.ODistributedException;
import com.orientechnologies.orient.server.replication.OReplicator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class ODistributedServerManager
extends OServerHandlerAbstract {
    public String id;
    protected ODistributedServerConfiguration config;
    protected OServer server;
    private volatile ODiscoverySignaler discoverySignaler;
    private volatile ODiscoveryListener discoveryListener;
    private OServerNetworkListener distributedNetworkListener;
    private OReplicator replicator;
    private final long startupDate = System.currentTimeMillis();
    private OLeaderNode leader;
    private OPeerNode peer;
    protected STATUS status = STATUS.OFFLINE;
    protected OClusterLogger logger = new OClusterLogger();

    @Override
    public void startup() {
        if (this.status == STATUS.DISABLED) {
            return;
        }
        this.setStatus(STATUS.STARTING);
        this.sendPresence();
        try {
            this.replicator = new OReplicator(this);
        }
        catch (IOException e) {
            throw new ODistributedException("Cannot start replicator agent");
        }
    }

    @Override
    public void shutdown() {
        if (this.discoverySignaler != null) {
            this.discoverySignaler.sendShutdown();
        }
        if (this.discoveryListener != null) {
            this.discoveryListener.sendShutdown();
        }
        this.replicator.shutdown();
        this.setStatus(STATUS.OFFLINE);
    }

    protected void sendPresence() {
        if (this.discoverySignaler != null) {
            return;
        }
        this.discoverySignaler = new ODiscoverySignaler(this, this.distributedNetworkListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void becomePeer(OClusterNetworkProtocol iConnection) {
        ODistributedServerManager oDistributedServerManager = this;
        synchronized (oDistributedServerManager) {
            if (this.discoverySignaler != null) {
                this.discoverySignaler.sendShutdown();
                this.discoverySignaler = null;
            }
            if (this.leader != null) {
                this.leader.shutdown();
                this.leader = null;
            }
            if (this.peer == null) {
                this.peer = new OPeerNode(this, iConnection);
            }
            this.setStatus(STATUS.PEER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void becameLeader() {
        ODistributedServerManager oDistributedServerManager = this;
        synchronized (oDistributedServerManager) {
            if (this.peer != null) {
                this.peer.shutdown();
                this.peer = null;
            }
            if (this.leader == null) {
                this.leader = new OLeaderNode(this);
                this.sendPresence();
            }
        }
        this.setStatus(STATUS.LEADER);
    }

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        this.server = iServer;
        try {
            this.config = new ODistributedServerConfiguration(iServer, this, iParams);
            if (this.status == STATUS.DISABLED) {
                return;
            }
            this.distributedNetworkListener = this.server.getListenerByProtocol(OClusterNetworkProtocol.class);
            if (this.distributedNetworkListener == null) {
                OLogManager.instance().error((Object)this, "Cannot find a configured network listener with 'distributed' protocol. Cannot start distributed node", null, OConfigurationException.class, new Object[0]);
            }
            this.id = InetAddress.getLocalHost().getHostAddress() + ":" + this.distributedNetworkListener.getInboundAddr().getPort();
        }
        catch (Exception e) {
            throw new OConfigurationException("Cannot configure OrientDB Server as Cluster Node", (Throwable)e);
        }
    }

    public boolean isLeader() {
        return this.leader != null;
    }

    public static String resolveNetworkHost(String iAddress) {
        String[] parts = iAddress.split(":");
        if (parts.length == 2) {
            try {
                InetAddress address = InetAddress.getByName(parts[0]);
                if (address != null) {
                    return address.getHostAddress() + ":" + parts[1];
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return iAddress;
    }

    public OLeaderNode getLeader() {
        return this.leader;
    }

    public long getRunningSince() {
        return System.currentTimeMillis() - this.startupDate;
    }

    public OServerNetworkListener getDistributedNetworkListener() {
        return this.distributedNetworkListener;
    }

    public String getName() {
        return this.config.name;
    }

    public String getId() {
        return this.id;
    }

    public OPeerNode getPeer() {
        return this.peer;
    }

    public ODistributedServerConfiguration getConfig() {
        return this.config;
    }

    public static String getNodeName(String iServerAddress, int iServerPort) {
        return iServerAddress + ":" + iServerPort;
    }

    public boolean itsMe(String iNodeId) {
        if (iNodeId.equals(this.id)) {
            return true;
        }
        String[] parts = iNodeId.split(":");
        return iNodeId.equals(this.distributedNetworkListener.getInboundAddr().getAddress().getHostAddress() + ":" + parts[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateHeartBeatTime() {
        ODistributedServerManager oDistributedServerManager = this;
        synchronized (oDistributedServerManager) {
            if (this.peer != null) {
                return this.peer.updateHeartBeatTime();
            }
        }
        return -1L;
    }

    public OReplicator getReplicator() {
        return this.replicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendClusterConfigurationToClients(String iDatabaseName, ODocument config) {
        for (OClientConnection c : OClientConnectionManager.instance().getConnections()) {
            if (c == null || c.database == null || !iDatabaseName.equals(c.database.getName()) || !(c.protocol.getChannel() instanceof OChannelBinary)) continue;
            OChannelBinary ch = (OChannelBinary)c.protocol.getChannel();
            this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "pushing distributed configuration to the connected client %s...", ch.socket.getRemoteSocketAddress());
            ch.acquireExclusiveLock();
            try {
                ch.writeByte((byte)3);
                ch.writeInt(Integer.MIN_VALUE);
                ch.writeByte((byte)80);
                ch.writeBytes(config.toStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                ch.releaseExclusiveLock();
            }
        }
    }

    private void setStatus(STATUS iStatus) {
        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.CLUSTER, OClusterLogger.DIRECTION.NONE, "server changed status %s -> %s", new Object[]{this.status, iStatus});
        this.status = iStatus;
    }

    public static enum STATUS {
        OFFLINE,
        STARTING,
        LEADER,
        PEER,
        DISABLED;

    }
}

