/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public class OServerCommandGetExportDatabase
extends OServerCommandAuthenticatedDbAbstract
implements OCommandOutputListener {
    private static final String[] NAMES = new String[]{"GET|export/*"};

    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: export/<database>/[<name>][?params*]");
        if (urlParts.length <= 2) {
            this.exportStandard(iRequest);
        }
        return false;
    }

    protected void exportStandard(OHttpRequest iRequest) throws InterruptedException, IOException {
        iRequest.data.commandInfo = "Database export";
        ODatabaseDocumentTx database = this.getProfiledDatabaseInstance(iRequest);
        this.sendStatus(iRequest, 200, "OK");
        this.sendResponseHeaders(iRequest, "application/x-gzip");
        this.writeLine(iRequest, "Content-Disposition: attachment; filename=" + database.getName() + ".gz");
        this.writeLine(iRequest, "Date: " + new Date());
        this.writeLine(iRequest, null);
        ODatabaseExport export = new ODatabaseExport((ODatabaseRecord)database, (OutputStream)new GZIPOutputStream(iRequest.channel.outStream), (OCommandOutputListener)this);
        export.exportDatabase();
        iRequest.channel.flush();
    }

    public void onMessage(String iText) {
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

