/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class OServerCommandGetServer
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"GET|server"};
    private static final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public OServerCommandGetServer() {
        super("server.info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        OStorage[] storages;
        void var9_9;
        OClientConnection[] conns;
        this.checkSyntax(iRequest.url, 1, "Syntax error: server");
        iRequest.data.commandInfo = "Server status";
        StringWriter jsonBuffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)jsonBuffer);
        json.beginObject();
        json.beginCollection(1, true, "connections");
        OClientConnection[] arr$ = conns = OServerMain.server().getManagedServer().getConnections();
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_9 < len$) {
            String connectedOn;
            String lastCommandOn;
            OClientConnection c = arr$[var9_9];
            ONetworkProtocolData data = c.data;
            DateFormat dateFormat = dateTimeFormat;
            synchronized (dateFormat) {
                lastCommandOn = dateTimeFormat.format(new Date(data.lastCommandReceived));
                connectedOn = dateTimeFormat.format(new Date(c.since));
            }
            json.beginObject(2);
            this.writeField(json, 2, "connectionId", c.id);
            this.writeField(json, 2, "remoteAddress", c.protocol.getChannel() != null ? c.protocol.getChannel().toString() : "Disconnected");
            this.writeField(json, 2, "db", c.database != null ? c.database.getName() : "-");
            this.writeField(json, 2, "user", c.database != null && c.database.getUser() != null ? c.database.getUser().getName() : "-");
            this.writeField(json, 2, "totalRequests", data.totalRequests);
            this.writeField(json, 2, "commandInfo", data.commandInfo);
            this.writeField(json, 2, "commandDetail", data.commandDetail);
            this.writeField(json, 2, "lastCommandOn", lastCommandOn);
            this.writeField(json, 2, "lastCommandInfo", data.lastCommandInfo);
            this.writeField(json, 2, "lastCommandDetail", data.lastCommandDetail);
            this.writeField(json, 2, "lastExecutionTime", data.lastCommandExecutionTime);
            this.writeField(json, 2, "totalWorkingTime", data.totalCommandExecutionTime);
            this.writeField(json, 2, "connectedOn", connectedOn);
            this.writeField(json, 2, "protocol", c.protocol.getType());
            this.writeField(json, 2, "clientId", data.clientId);
            StringBuilder stringBuilder = new StringBuilder();
            if (data.driverName != null) {
                stringBuilder.append(data.driverName);
                stringBuilder.append(" v");
                stringBuilder.append(data.driverVersion);
                stringBuilder.append(" Protocol v");
                stringBuilder.append(data.protocolVersion);
            }
            this.writeField(json, 2, "driver", stringBuilder.toString());
            json.endObject(2);
            ++var9_9;
        }
        json.endCollection(1, false);
        json.beginCollection(1, true, "dbs");
        Map<String, OResourcePool<String, ODatabaseDocumentTx>> dbPool = OSharedDocumentDatabase.getDatabasePools();
        for (Map.Entry<String, OResourcePool<String, ODatabaseDocumentTx>> entry : dbPool.entrySet()) {
            for (ODatabaseDocumentTx db : entry.getValue().getResources()) {
                json.beginObject(2);
                this.writeField(json, 2, "db", db.getName());
                this.writeField(json, 2, "user", db.getUser() != null ? db.getUser().getName() : "-");
                this.writeField(json, 2, "open", db.isClosed() ? "closed" : "open");
                this.writeField(json, 2, "storage", db.getStorage().getClass().getSimpleName());
                json.endObject(2);
            }
        }
        json.endCollection(1, false);
        json.beginCollection(1, true, "storages");
        for (OStorage oStorage : storages = OServerMain.server().getManagedServer().getOpenedStorages()) {
            json.beginObject(2);
            this.writeField(json, 2, "name", oStorage.getName());
            this.writeField(json, 2, "type", oStorage.getClass().getSimpleName());
            this.writeField(json, 2, "path", oStorage instanceof OStorageLocal ? ((OStorageLocal)oStorage).getStoragePath().replace('\\', '/') : "");
            this.writeField(json, 2, "activeUsers", oStorage.getUsers());
            json.endObject(2);
        }
        json.endCollection(1, false);
        json.beginCollection(2, true, "properties");
        for (OServerEntryConfiguration oServerEntryConfiguration : OServerMain.server().getConfiguration().properties) {
            json.beginObject(3, true, null);
            json.writeAttribute(4, false, "name", (Object)oServerEntryConfiguration.name);
            json.writeAttribute(4, false, "value", (Object)oServerEntryConfiguration.value);
            json.endObject(3, true);
        }
        json.endCollection(2, true);
        json.beginObject(1, true, (Object)"profiler");
        json.beginCollection(2, true, "hookValues");
        for (String h : OProfiler.getInstance().getHooks()) {
            json.beginObject(3);
            this.writeField(json, 3, "name", h);
            this.writeField(json, 3, "value", OProfiler.getInstance().getHookValue(h));
            json.endObject(3);
        }
        json.endCollection(2, false);
        json.beginCollection(2, true, "counters");
        for (String c : OProfiler.getInstance().getCounters()) {
            json.beginObject(3);
            this.writeField(json, 3, "name", c);
            this.writeField(json, 3, "value", OProfiler.getInstance().getCounter(c));
            json.endObject(3);
        }
        json.endCollection(2, false);
        json.beginCollection(2, true, "stats");
        for (String s : OProfiler.getInstance().getStats()) {
            OProfiler.OProfilerEntry oProfilerEntry = OProfiler.getInstance().getStat(s);
            json.beginObject(3);
            this.writeField(json, 3, "name", s);
            this.writeField(json, 3, "total", oProfilerEntry.items);
            this.writeField(json, 3, "averageElapsed", oProfilerEntry.average);
            this.writeField(json, 3, "minElapsed", oProfilerEntry.min);
            this.writeField(json, 3, "maxElapsed", oProfilerEntry.max);
            this.writeField(json, 3, "lastElapsed", oProfilerEntry.last);
            this.writeField(json, 3, "totalElapsed", oProfilerEntry.total);
            json.endObject(3);
        }
        json.endCollection(2, false);
        json.beginCollection(2, true, "chronos");
        for (String c : OProfiler.getInstance().getChronos()) {
            OProfiler.OProfilerEntry oProfilerEntry = OProfiler.getInstance().getChrono(c);
            json.beginObject(3);
            this.writeField(json, 3, "name", c);
            this.writeField(json, 3, "total", oProfilerEntry.items);
            this.writeField(json, 3, "averageElapsed", oProfilerEntry.average);
            this.writeField(json, 3, "minElapsed", oProfilerEntry.min);
            this.writeField(json, 3, "maxElapsed", oProfilerEntry.max);
            this.writeField(json, 3, "lastElapsed", oProfilerEntry.last);
            this.writeField(json, 3, "totalElapsed", oProfilerEntry.total);
            json.endObject(3);
        }
        json.endCollection(2, false);
        json.endObject(1);
        json.endObject();
        this.sendTextContent(iRequest, 200, "OK", null, "application/json", jsonBuffer.toString());
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    private void writeField(OJSONWriter json, int iLevel, String iAttributeName, Object iAttributeValue) throws IOException {
        json.writeAttribute(iLevel, true, iAttributeName, (Object)(iAttributeValue != null ? iAttributeValue.toString() : "-"));
    }
}

