/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.multipart;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentInputStream;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class OHttpMultipartFileToDiskContentParser
implements OHttpMultipartContentParser<InputStream> {
    protected String path;

    public OHttpMultipartFileToDiskContentParser(String iPath) {
        this.path = iPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream parse(OHttpRequest iRequest, Map<String, String> headers, OHttpMultipartContentInputStream in, ODatabaseRecord database) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer);
        json.beginObject();
        String fileName = headers.get("filename");
        int fileSize = 0;
        if (fileName.charAt(0) == '\"') {
            fileName = new String(fileName.substring(1));
        }
        if (fileName.charAt(fileName.length() - 1) == '\"') {
            fileName = new String(fileName.substring(0, fileName.length() - 1));
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.path + fileName.toString()));
        try {
            int b;
            while ((b = in.read()) > 0) {
                ((OutputStream)out).write(b);
                ++fileSize;
            }
        }
        finally {
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        json.writeAttribute(1, true, "name", (Object)fileName);
        json.writeAttribute(1, true, "type", (Object)headers.get("Content-Type"));
        json.writeAttribute(1, true, "size", (Object)fileSize);
        json.endObject();
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }
}

