/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.multipart;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentInputStream;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentParser;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

public abstract class OHttpMultipartRequestCommand<B, F>
extends OServerCommandAuthenticatedDbAbstract {
    private STATUS parseStatus = STATUS.STATUS_EXPECTED_BOUNDARY;

    public void parse(OHttpRequest iRequest, OHttpMultipartContentParser<B> standardContentParser, OHttpMultipartContentParser<F> fileContentParser, ODatabaseRecord database) throws Exception {
        int in;
        boolean endRequest = false;
        OHttpMultipartContentInputStream contentIn = new OHttpMultipartContentInputStream(iRequest.multipartStream, iRequest.boundary);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        while (!endRequest && (in = iRequest.multipartStream.read()) > 0) {
            char currChar = (char)in;
            switch (this.parseStatus) {
                case STATUS_EXPECTED_BOUNDARY: {
                    this.readBoundary(iRequest, currChar);
                    this.parseStatus = STATUS.STATUS_EXPECTED_BOUNDARY_CRLF;
                    break;
                }
                case STATUS_EXPECTED_BOUNDARY_CRLF: {
                    endRequest = this.readBoundaryCrLf(iRequest, currChar, endRequest);
                    this.parseStatus = STATUS.STATUS_EXPECTED_PART_HEADERS;
                    break;
                }
                case STATUS_EXPECTED_PART_HEADERS: {
                    this.parsePartHeaders(iRequest, currChar, endRequest, headers);
                    this.parseStatus = STATUS.STATUS_EXPECTED_PART_CONTENT;
                    break;
                }
                case STATUS_EXPECTED_PART_CONTENT: {
                    iRequest.multipartStream.setSkipInput(in);
                    contentIn.reset();
                    if (((HashMap)headers).get("filename") != null) {
                        this.parseFileContent(iRequest, fileContentParser, headers, contentIn, database);
                        break;
                    }
                    this.parseBaseContent(iRequest, standardContentParser, headers, contentIn, database);
                    break;
                }
                case STATUS_EXPECTED_END_REQUEST: {
                    iRequest.multipartStream.setSkipInput(in);
                    endRequest = OHttpMultipartHelper.isEndRequest(iRequest);
                    this.parseStatus = !endRequest ? STATUS.STATUS_EXPECTED_BOUNDARY_CRLF : STATUS.STATUS_EXPECTED_BOUNDARY;
                }
            }
        }
        this.parseStatus = STATUS.STATUS_EXPECTED_BOUNDARY;
    }

    protected boolean readBoundaryCrLf(OHttpRequest iRequest, char currChar, boolean endRequest) throws IOException {
        if (currChar == '\r') {
            int in = iRequest.multipartStream.read();
            currChar = (char)in;
            if (currChar == '\n') {
                return false;
            }
        } else if (currChar == '-') {
            int in = iRequest.multipartStream.read();
            currChar = (char)in;
            if (currChar == '-') {
                endRequest = true;
            } else {
                this.sendTextContent(iRequest, 405, "Wrong request: Expected -", null, "text/plain", "Wrong request: Expected -");
                endRequest = true;
            }
        } else {
            this.sendTextContent(iRequest, 405, "Wrong request: Expected CR/LF", null, "text/plain", "Wrong request: Expected CR/LF");
            endRequest = true;
        }
        return endRequest;
    }

    protected void readBoundary(OHttpRequest iRequest, char currChar) throws IOException {
        int in;
        int boundaryCursor = 0;
        for (int i = 0; i < 2; ++i) {
            if (currChar != '-') {
                this.sendTextContent(iRequest, 405, "Wrong request: Expected boundary", null, "text/plain", "Wrong request: Expected boundary");
                return;
            }
            in = iRequest.multipartStream.read();
            currChar = (char)in;
        }
        while (boundaryCursor < iRequest.boundary.length()) {
            if (currChar != iRequest.boundary.charAt(boundaryCursor)) {
                this.sendTextContent(iRequest, 405, "Wrong request: Expected boundary", null, "text/plain", "Wrong request: Expected boundary");
            }
            if (++boundaryCursor >= iRequest.boundary.length()) continue;
            in = iRequest.multipartStream.read();
            currChar = (char)in;
        }
    }

    protected void parsePartHeaders(OHttpRequest iRequest, char currChar, boolean endRequest, HashMap<String, String> headers) throws IOException {
        StringBuilder headerName = new StringBuilder();
        boolean endOfHeaders = false;
        while (!endOfHeaders) {
            int in;
            headerName.append(currChar);
            if (OHttpMultipartHelper.isMultipartPartHeader(headerName)) {
                currChar = this.parseHeader(iRequest, headers, headerName.toString());
                headerName.setLength(0);
            }
            if (currChar == '\r') {
                in = iRequest.multipartStream.read();
                currChar = (char)in;
                if (currChar != '\n' || (currChar = (char)(in = iRequest.multipartStream.read())) != '\r' || (currChar = (char)(in = iRequest.multipartStream.read())) != '\n') continue;
                endOfHeaders = true;
                continue;
            }
            in = iRequest.multipartStream.read();
            currChar = (char)in;
        }
    }

    protected char parseHeader(OHttpRequest iRequest, HashMap<String, String> headers, String headerName) throws IOException {
        StringBuilder header = new StringBuilder();
        boolean endOfHeader = false;
        int in = iRequest.multipartStream.read();
        char currChar = (char)in;
        if (currChar == ':') {
            in = iRequest.multipartStream.read();
            currChar = (char)in;
            if (currChar != ' ') {
                this.sendTextContent(iRequest, 405, "Wrong request part header: Expected ' ' (header: " + headerName + ")", null, "text/plain", "Wrong request part header: Expected ' ' (header: " + headerName + ")");
            }
        } else if (currChar != '=') {
            this.sendTextContent(iRequest, 405, "Wrong request part header: Expected ':' (header: " + headerName + ")", null, "text/plain", "Wrong request part header: Expected ':' (header: " + headerName + ")");
        }
        while (!endOfHeader) {
            in = iRequest.multipartStream.read();
            currChar = (char)in;
            if (currChar == ';') {
                if (header.charAt(0) == '\"') {
                    header.deleteCharAt(0);
                }
                if (header.charAt(header.length() - 1) == '\"') {
                    header.deleteCharAt(header.length() - 1);
                }
                headers.put(headerName, header.toString());
                in = iRequest.multipartStream.read();
                return (char)in;
            }
            if (currChar == '\r') {
                if (header.charAt(0) == '\"') {
                    header.deleteCharAt(0);
                }
                if (header.charAt(header.length() - 1) == '\"') {
                    header.deleteCharAt(header.length() - 1);
                }
                headers.put(headerName, header.toString());
                return currChar;
            }
            header.append(currChar);
        }
        return currChar;
    }

    protected void parseBaseContent(OHttpRequest iRequest, OHttpMultipartContentParser<B> contentParser, HashMap<String, String> headers, OHttpMultipartContentInputStream in, ODatabaseRecord database) throws Exception {
        B result = contentParser.parse(iRequest, headers, in, database);
        this.parseStatus = STATUS.STATUS_EXPECTED_END_REQUEST;
        this.processBaseContent(iRequest, result, headers);
        headers.clear();
    }

    protected void parseFileContent(OHttpRequest iRequest, OHttpMultipartContentParser<F> contentParser, HashMap<String, String> headers, OHttpMultipartContentInputStream in, ODatabaseRecord database) throws Exception {
        F result = contentParser.parse(iRequest, headers, in, database);
        this.parseStatus = STATUS.STATUS_EXPECTED_END_REQUEST;
        this.processFileContent(iRequest, result, headers);
        headers.clear();
    }

    protected abstract void processBaseContent(OHttpRequest var1, B var2, HashMap<String, String> var3) throws Exception;

    protected abstract void processFileContent(OHttpRequest var1, F var2, HashMap<String, String> var3) throws Exception;

    protected abstract String getFileParamenterName();

    protected abstract String getDocumentParamenterName();

    protected static enum STATUS {
        STATUS_EXPECTED_BOUNDARY,
        STATUS_EXPECTED_BOUNDARY_CRLF,
        STATUS_EXPECTED_PART_HEADERS,
        STATUS_EXPECTED_PART_CONTENT,
        STATUS_EXPECTED_END_REQUEST;

    }
}

