/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.replication;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.replication.ODistributedDatabaseInfo;
import com.orientechnologies.orient.server.replication.ODistributedSynchronizationException;
import com.orientechnologies.orient.server.replication.ONodeConnection;
import com.orientechnologies.orient.server.replication.OReplicator;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

public class ODistributedNode {
    private final OReplicator replicator;
    private final String id;
    public String networkAddress;
    public int networkPort;
    public Date connectedOn;
    private Map<String, ODistributedDatabaseInfo> databases = new HashMap<String, ODistributedDatabaseInfo>();
    protected OClusterLogger logger = new OClusterLogger();

    public ODistributedNode(OReplicator iReplicator, String iId) throws IOException {
        this.replicator = iReplicator;
        this.id = iId;
        String[] parts = iId.split(":");
        this.networkAddress = parts[0];
        this.networkPort = Integer.parseInt(parts[1]);
        this.logger.setNode(iId);
    }

    public ODistributedDatabaseInfo getDatabase(String iDatabaseName) {
        return this.databases.get(iDatabaseName);
    }

    public ODistributedDatabaseInfo removeDatabase(String iDatabaseName) throws IOException {
        ODistributedDatabaseInfo db = this.databases.remove(iDatabaseName);
        if (db != null) {
            db.close();
        }
        return db;
    }

    public ODistributedDatabaseInfo getOrCreateDatabaseEntry(String iDatabaseName) throws IOException {
        ODistributedDatabaseInfo db = this.databases.get(iDatabaseName);
        if (db == null) {
            db = this.createDatabaseEntry(iDatabaseName, ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH);
        }
        return db;
    }

    protected ODistributedDatabaseInfo createDatabaseEntry(String dbName, ODistributedDatabaseInfo.SYNCH_TYPE iSynchType) throws IOException {
        ODistributedDatabaseInfo obj = this.databases.get(dbName);
        if (obj != null) {
            this.removeDatabase(dbName);
        }
        obj = new ODistributedDatabaseInfo(this.id, dbName, this.replicator.getReplicatorUser().name, this.replicator.getReplicatorUser().password, iSynchType, ODistributedDatabaseInfo.STATUS_TYPE.OFFLINE);
        this.databases.put(dbName, obj);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDatabaseReplication(ODistributedDatabaseInfo iDatabase) throws IOException {
        if (iDatabase == null) {
            throw new IllegalArgumentException("Database is null");
        }
        this.logger.setDatabase(iDatabase.databaseName);
        ODistributedNode oDistributedNode = this;
        synchronized (oDistributedNode) {
            this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "starting replication against distributed node", new Object[0]);
            try {
                this.databases.put(iDatabase.databaseName, iDatabase);
                if (iDatabase.connection == null) {
                    iDatabase.connection = new ONodeConnection(this.replicator, this.id, this.replicator.getConflictResolver());
                }
                iDatabase.connection.synchronize(iDatabase.databaseName, this.replicator.getLocalDatabaseConfiguration(iDatabase.databaseName));
                iDatabase.setOnline();
            }
            catch (Exception e) {
                this.removeDatabase(iDatabase.databaseName);
                this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "cannot find database on remote server. Removing it from shared list", e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDatabaseReplication(ODistributedDatabaseInfo iDatabase) {
        ODistributedNode oDistributedNode = this;
        synchronized (oDistributedNode) {
            this.logger.setDatabase(iDatabase.databaseName);
            iDatabase.setOffline();
            this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "stopped replication against distributed node", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDatabaseAlignment(ODistributedDatabaseInfo iDatabase, String iOptions) throws IOException {
        if (iDatabase == null) {
            throw new IllegalArgumentException("Database is null");
        }
        this.logger.setDatabase(iDatabase.databaseName);
        ODistributedNode oDistributedNode = this;
        synchronized (oDistributedNode) {
            if (!iDatabase.isOnline()) {
                throw new IllegalArgumentException("Database '" + iDatabase.databaseName + "' is not replicated");
            }
            this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "starting alignment against distributed node", new Object[0]);
            try {
                this.databases.put(iDatabase.databaseName, iDatabase);
                if (iDatabase.connection == null) {
                    iDatabase.connection = new ONodeConnection(this.replicator, this.id, this.replicator.getConflictResolver());
                }
                iDatabase.setSynchronizing();
                iDatabase.connection.align(iDatabase.databaseName, iOptions);
                iDatabase.setOnline();
            }
            catch (Exception e) {
                this.removeDatabase(iDatabase.databaseName);
                this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "cannot find database on remote server. Removing it from shared list", e, new Object[0]);
            }
        }
    }

    public void propagateChange(ORecordOperation iRequest, ODistributedDatabaseInfo.SYNCH_TYPE iRequestType, boolean iResume) throws IOException {
        ORecordInternal record = iRequest.getRecord();
        if (record == null) {
            return;
        }
        ODistributedDatabaseInfo databaseEntry = this.databases.get(record.getDatabase().getName());
        if (databaseEntry == null) {
            return;
        }
        try {
            databaseEntry.connection.propagateChange(databaseEntry, iRequest, iRequestType, record);
        }
        catch (Exception e) {
            this.handleError(iRequest, iRequestType, e, iResume);
        }
    }

    public ORecord<?> requestRecord(String iDatabaseName, ORecordId rid) {
        ODistributedDatabaseInfo databaseEntry = this.databases.get(iDatabaseName);
        if (databaseEntry != null) {
            try {
                return databaseEntry.connection.requestRecord(databaseEntry, rid);
            }
            catch (Exception e) {
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.IN, "Error on retrieving record %s from remote server", rid);
            }
        }
        return null;
    }

    public ODistributedDatabaseInfo copyDatabase(ODatabaseRecord iDb, String iRemoteEngine) throws IOException {
        ODistributedDatabaseInfo db = this.getDatabase(iDb.getName());
        if (db != null && db.isOnline()) {
            throw new ODistributedSynchronizationException("Database '" + iDb.getName() + "' is already shared on remote server node '" + this.id + "'");
        }
        db = this.createDatabaseEntry(iDb.getName(), ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH);
        long time = System.currentTimeMillis();
        try {
            this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "copying database to the remote server via streaming across the network...", new Object[0]);
            db.setSynchronizing();
            if (db.connection == null) {
                db.connection = new ONodeConnection(this.replicator, this.id, this.replicator.getConflictResolver());
            }
            db.connection.copy(iDb, db.databaseName, db.userName, db.userPassword, iRemoteEngine);
        }
        catch (IOException e) {
            this.removeDatabase(iDb.getName());
            throw e;
        }
        catch (Exception e) {
            this.removeDatabase(iDb.getName());
            this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "Error on copying database", new Object[0]);
            throw new OIOException("Error on copying database", (Throwable)e);
        }
        this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "sharing completed (%dms)", System.currentTimeMillis() - time);
        return db;
    }

    public String toString() {
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    public void disconnect() throws IOException {
        for (ODistributedDatabaseInfo db : this.databases.values()) {
            db.close();
            if (db.connection == null) continue;
            db.connection.disconnect();
        }
        this.databases.clear();
    }

    public long[] getLogRange(String iDatabaseName) throws IOException {
        return new long[]{this.databases.get(iDatabaseName).getLog().getFirstOperationId(), this.databases.get(iDatabaseName).getLog().getLastOperationId()};
    }

    protected void handleError(ORecordOperation iRequest, ODistributedDatabaseInfo.SYNCH_TYPE iRequestType, Exception iException, boolean iResume) throws RuntimeException, IOException {
        HashSet<ODistributedDatabaseInfo> currentDbList = new HashSet<ODistributedDatabaseInfo>(this.databases.values());
        this.disconnect();
        this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "seems down, retrying to connect...", new Object[0]);
        if (iResume) {
            try {
                for (ODistributedDatabaseInfo dbEntry : currentDbList) {
                    this.startDatabaseReplication(dbEntry);
                }
            }
            catch (IOException e) {
                this.logger.log((Object)this, Level.WARNING, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "is down, remove it from replication", new Object[0]);
            }
        }
        if (iRequestType == ODistributedDatabaseInfo.SYNCH_TYPE.SYNCH && iException instanceof RuntimeException) {
            throw (RuntimeException)iException;
        }
    }

    public void registerDatabase(ODistributedDatabaseInfo iDatabaseEntry) throws IOException {
        this.databases.put(iDatabaseEntry.databaseName, iDatabaseEntry);
    }
}

