/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.replication;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;

public class ODistributedRemoteAsynchEventListener
implements ORemoteServerEventListener {
    private ODistributedServerManager manager;
    private ORemoteServerEventListener wrapped;
    private String nodeId;

    public ODistributedRemoteAsynchEventListener(ODistributedServerManager iServerManager, ORemoteServerEventListener iToWrap, String iNodeId) {
        this.manager = iServerManager;
        this.wrapped = iToWrap;
        this.nodeId = iNodeId;
    }

    public void onRequest(byte iRequestCode, Object obj) {
        if (iRequestCode == 127) {
            try {
                ODocument updateCfg = this.manager.getLeader().updatePeerDatabases(this.nodeId, (ODocument)obj);
                this.manager.getReplicator().updateConfiguration(updateCfg);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "CLUSTER <%s>: error on updating leader's database list for peer %s", (Throwable)e, new Object[]{this.manager.getConfig().name, this.nodeId});
            }
        } else if (this.wrapped != null) {
            this.wrapped.onRequest(iRequestCode, obj);
        }
    }
}

