/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.replication;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class OOperationLog
extends OSingleFileSegment {
    public static final String EXTENSION = ".dol";
    private static final int DEF_START_SIZE = 262144;
    private static final int OFFSET_SERIAL = 0;
    private static final int OFFSET_OPERAT = 8;
    private static final int OFFSET_RID = 9;
    private static final int OFFSET_DATE = 19;
    private static final int RECORD_SIZE = 27;
    private AtomicLong serial = new AtomicLong();
    private final String nodeId;
    private final boolean synchEnabled;
    private final OClusterLogger logger = new OClusterLogger();
    private OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);

    public OOperationLog(String iNodeId, String iDatabase, boolean iReset) throws IOException {
        super("${ORIENTDB_HOME}/replication/" + iDatabase + "/" + iNodeId.replace('.', '_').replace(':', '-') + EXTENSION, OGlobalConfiguration.DISTRIBUTED_LOG_TYPE.getValueAsString());
        this.nodeId = iNodeId;
        this.synchEnabled = OGlobalConfiguration.DISTRIBUTED_LOG_SYNCH.getValueAsBoolean();
        this.logger.setNode(this.nodeId);
        this.logger.setDatabase(iDatabase);
        this.file.setFailCheck(false);
        if (this.exists()) {
            if (iReset) {
                this.reset();
            } else {
                this.open();
            }
        } else {
            this.create(262144);
        }
    }

    public boolean open() throws IOException {
        boolean result = super.open();
        this.serial.set(this.getLastOperationId() + 1L);
        return result;
    }

    public void create(int iStartSize) throws IOException {
        super.create(iStartSize);
        this.serial.set(0L);
    }

    public void reset() throws IOException {
        this.delete();
        this.create(262144);
    }

    public long appendLocalLog(byte iOperation, ORecordId iRID) throws IOException {
        return this.appendLog(this.serial.getAndIncrement(), iOperation, iRID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long appendLog(long iSerial, byte iOperation, ORecordId iRID) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            this.logger.log((Object)this, Level.FINE, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.NONE, "Journaled operation #%d as %s against record %s", iSerial, ORecordOperation.getName((int)iOperation), iRID);
            int offset = this.file.allocateSpace(27);
            this.file.writeLong((long)offset, iSerial);
            this.file.writeByte((long)(offset += 8), iOperation);
            this.file.writeShort((long)(++offset), (short)iRID.clusterId);
            this.file.writeLong((long)(offset += 2), iRID.clusterPosition);
            this.file.writeLong((long)(offset += 8), System.currentTimeMillis());
            if (this.synchEnabled) {
                this.file.synch();
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return iSerial;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int findOperationId(long iOperationId) throws IOException {
        if (iOperationId == -1L) {
            return this.totalEntries() - 1;
        }
        for (int i = this.totalEntries() - 1; i > -1; --i) {
            long serial = this.file.readLong((long)(i * 27));
            if (serial != iOperationId) continue;
            return i;
        }
        return -1;
    }

    public ORecordOperation getEntry(int iPosition, ORecordOperation iEntry) throws IOException {
        int pos = iPosition * 27;
        iEntry.serial = this.file.readLong((long)pos);
        iEntry.type = this.file.readByte((long)(pos + 8));
        iEntry.record = new ORecordId((int)this.file.readShort((long)(pos + 9)), this.file.readLong((long)(pos + 9 + 2)));
        iEntry.date = this.file.readLong((long)(pos + 19));
        return iEntry;
    }

    public long getFirstOperationId() throws IOException {
        if (this.isEmpty()) {
            return -1L;
        }
        return this.file.readLong(0L);
    }

    public long getLastOperationId() throws IOException {
        if (this.isEmpty()) {
            return -1L;
        }
        return this.file.readLong((long)(this.file.getFilledUpTo() - 27));
    }

    public boolean isEmpty() {
        return this.file.getFilledUpTo() == 0;
    }

    public int totalEntries() {
        return this.file.getFilledUpTo() / 27;
    }
}

