/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.replication;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.clustering.OClusterLogger;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.replication.ODistributedDatabaseInfo;
import com.orientechnologies.orient.server.replication.ODistributedException;
import com.orientechnologies.orient.server.replication.ODistributedNode;
import com.orientechnologies.orient.server.replication.ONodeConnection;
import com.orientechnologies.orient.server.replication.OOperationLog;
import com.orientechnologies.orient.server.replication.OReplicatorRecordHook;
import com.orientechnologies.orient.server.replication.conflict.OReplicationConflictResolver;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class OReplicator {
    public static final String DIRECTORY_NAME = "${ORIENTDB_HOME}/replication";
    private ODocument clusterConfiguration;
    private OReplicatorRecordHook trigger;
    private volatile STATUS status = STATUS.ONLINE;
    private Map<String, ODistributedNode> nodes = new HashMap<String, ODistributedNode>();
    private OServerUserConfiguration replicatorUser;
    private ODistributedServerManager manager;
    private Map<String, OOperationLog> localLogs = new HashMap<String, OOperationLog>();
    private final Set<String> ignoredClusters = new HashSet<String>();
    private final Set<String> ignoredDocumentClasses = new HashSet<String>();
    private final Set<ORecordId> ignoredRecords = new HashSet<ORecordId>();
    private final OReplicationConflictResolver conflictResolver;
    private final OClusterLogger logger = new OClusterLogger();

    public OReplicator(ODistributedServerManager iManager) throws IOException {
        this.manager = iManager;
        this.trigger = new OReplicatorRecordHook(this);
        this.replicatorUser = OServerMain.server().getConfiguration().getUser("replicator");
        String conflictResolvertStrategy = iManager.getConfig().replicationConflictResolverConfig.get("strategy");
        try {
            this.conflictResolver = (OReplicationConflictResolver)Class.forName(conflictResolvertStrategy).newInstance();
            this.conflictResolver.config(this, iManager.getConfig().replicationConflictResolverConfig);
        }
        catch (Exception e) {
            throw new ODistributedException("Cannot create the configured replication conflict resolver: " + conflictResolvertStrategy);
        }
    }

    public void shutdown() {
        this.nodes.clear();
        this.status = STATUS.OFFLINE;
    }

    public void updateConfiguration(ODocument iDocument) throws IOException {
        if (iDocument == null) {
            return;
        }
        this.clusterConfiguration = iDocument;
        for (String dbName : this.clusterConfiguration.fieldNames()) {
            ODocument db = (ODocument)this.clusterConfiguration.field(dbName);
            Collection dbNodes = (Collection)db.field("nodes");
            for (ODocument node : dbNodes) {
                this.startReplication((String)node.field("id"), dbName, node.field("mode").toString());
            }
        }
    }

    public boolean connect(String nodeId, String dbName, String mode) throws IOException {
        if (this.manager.itsMe(nodeId)) {
            return false;
        }
        ODistributedNode dNode = this.getOrCreateDistributedNode(nodeId);
        ODistributedDatabaseInfo db = dNode.getDatabase(dbName);
        if (db == null) {
            db = dNode.createDatabaseEntry(dbName, ODistributedDatabaseInfo.SYNCH_TYPE.valueOf(mode.toUpperCase()));
        }
        if (db.connection == null) {
            db.connection = new ONodeConnection(this, nodeId, this.getConflictResolver());
        }
        this.getOrCreateLocalLog(dbName);
        return db.status != ODistributedDatabaseInfo.STATUS_TYPE.ONLINE;
    }

    public void startReplication(String nodeId, String dbName, String mode) throws IOException {
        if (!this.connect(nodeId, dbName, mode)) {
            return;
        }
        ODistributedNode dNode = this.getOrCreateDistributedNode(nodeId);
        ODistributedDatabaseInfo db = dNode.getOrCreateDatabaseEntry(dbName);
        dNode.startDatabaseReplication(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDistributedNode(String iNodeId, IOException iCause) {
        OLogManager.instance().warn((Object)this, "<-> NODE %s: error connecting distributed node. Remove it from the available nodes", (Throwable)iCause, new Object[]{iNodeId});
        OReplicator oReplicator = this;
        synchronized (oReplicator) {
            this.nodes.remove(iNodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distributeRequest(ORecordOperation iTransactionEntry) throws IOException {
        OOperationLog log;
        String dbName = iTransactionEntry.getRecord().getDatabase().getName();
        OReplicator oReplicator = this;
        synchronized (oReplicator) {
            log = this.localLogs.get(dbName);
            if (log == null) {
                return;
            }
        }
        iTransactionEntry.serial = log.appendLocalLog(iTransactionEntry.type, (ORecordId)iTransactionEntry.getRecord().getIdentity());
        if (this.nodes.isEmpty()) {
            return;
        }
        this.logger.setDatabase(dbName);
        for (ODistributedNode node : this.nodes.values()) {
            this.logger.setNode(node.getName());
            ODistributedDatabaseInfo dbEntry = node.getDatabase(dbName);
            if (dbEntry == null) continue;
            if (dbEntry.status != ODistributedDatabaseInfo.STATUS_TYPE.ONLINE) {
                this.logger.log((Object)this, Level.INFO, OClusterLogger.TYPE.REPLICATION, OClusterLogger.DIRECTION.OUT, "database status %s: the change is not propagated", new Object[]{dbEntry.status});
                continue;
            }
            node.propagateChange(iTransactionEntry, dbEntry.synchType, true);
        }
    }

    public ODocument getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setStatus(STATUS iOnline) {
        this.status = iOnline;
    }

    public ODocument getLocalDatabaseConfiguration() throws IOException {
        ODocument doc = new ODocument();
        for (String dbName : OServerMain.server().getAvailableStorageNames().keySet()) {
            doc.field(dbName, this.getLocalDatabaseConfiguration(dbName));
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ODocument> getLocalDatabaseConfiguration(String dbName) throws IOException {
        HashSet<ODocument> set = new HashSet<ODocument>();
        File dbDir = new File(OSystemVariableResolver.resolveSystemVariables((String)("${ORIENTDB_HOME}/replication/" + dbName)));
        if (dbDir.exists() && dbDir.isDirectory()) {
            for (File f : dbDir.listFiles()) {
                String nodeId;
                if (!f.isFile() || !f.getName().endsWith(".dol") || this.manager.itsMe(nodeId = f.getName().substring(0, f.getName().indexOf(46)).replace('_', '.').replace('-', ':'))) continue;
                OReplicator oReplicator = this;
                synchronized (oReplicator) {
                    ODistributedNode node = this.getOrCreateDistributedNode(nodeId);
                    if (node.getDatabase(dbName) == null) {
                        node.registerDatabase(node.createDatabaseEntry(dbName, ODistributedDatabaseInfo.SYNCH_TYPE.ASYNCH));
                    }
                    ODocument nodeCfg = new ODocument();
                    set.add(nodeCfg);
                    try {
                        long[] logRange = node.getLogRange(dbName);
                        nodeCfg.field("node", (Object)nodeId);
                        nodeCfg.field("firstLog", (Object)logRange[0]);
                        nodeCfg.field("lastLog", (Object)logRange[1]);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
        return set;
    }

    public boolean isIgnoredDocumentClass(String ignoredDocumentClass) {
        return this.ignoredDocumentClasses.contains(ignoredDocumentClass);
    }

    public void addIgnoredDocumentClass(String ignoredDocumentClass) {
        this.ignoredDocumentClasses.add(ignoredDocumentClass);
    }

    public void removeIgnoreDocumentClasses(String ignoredDocumentClass) {
        this.ignoredDocumentClasses.remove(ignoredDocumentClass);
    }

    public boolean isIgnoredCluster(String ignoredCluster) {
        return this.ignoredClusters.contains(ignoredCluster);
    }

    public void addIgnoredCluster(String ignoredCluster) {
        this.ignoredClusters.add(ignoredCluster);
    }

    public void removeIgnoreCluster(String ignoredCluster) {
        this.ignoredClusters.remove(ignoredCluster);
    }

    public boolean isIgnoredRecord(ORecordId ignoredRecord) {
        return this.ignoredRecords.contains(ignoredRecord);
    }

    public void addIgnoredRecord(ORecordId ignoredRecord) {
        this.ignoredRecords.add(ignoredRecord);
    }

    public void removeIgnoreRecord(ORecordId ignoredRecord) {
        this.ignoredRecords.remove(ignoredRecord);
    }

    public OReplicationConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedNode getOrCreateDistributedNode(String nodeId) throws IOException {
        if (this.manager.itsMe(nodeId)) {
            throw new IllegalArgumentException("Cannot create a remote node with the id of the current server: " + nodeId);
        }
        OReplicator oReplicator = this;
        synchronized (oReplicator) {
            ODistributedNode dNode = this.nodes.get(nodeId);
            if (dNode == null) {
                dNode = new ODistributedNode(this, nodeId);
                this.nodes.put(nodeId, dNode);
            }
            return dNode;
        }
    }

    public ODistributedNode getNode(String iNodeId) {
        return this.nodes.get(iNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OOperationLog getOperationLog(String iNodeId, String iDatabaseName) throws IOException {
        OReplicator oReplicator = this;
        synchronized (oReplicator) {
            ODistributedDatabaseInfo db;
            if (this.manager.itsMe(iNodeId)) {
                return this.getOrCreateLocalLog(iDatabaseName);
            }
            ODistributedNode node = this.nodes.get(iNodeId);
            if (node != null && (db = node.getDatabase(iDatabaseName)) != null) {
                return db.getLog();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplicated(String iDatabaseName) {
        OReplicator oReplicator = this;
        synchronized (oReplicator) {
            return this.localLogs.containsKey(iDatabaseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAnyPreviousReplicationLog(String iDatabaseName) throws IOException {
        OReplicator oReplicator = this;
        synchronized (oReplicator) {
            OOperationLog log = this.localLogs.get(iDatabaseName);
            if (log == null) {
                this.localLogs.put(iDatabaseName, new OOperationLog(this.manager.getId(), iDatabaseName, true));
            } else {
                log.reset();
            }
        }
    }

    public ODistributedServerManager getManager() {
        return this.manager;
    }

    public OServerUserConfiguration getReplicatorUser() {
        return this.replicatorUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OOperationLog getOrCreateLocalLog(String dbName) throws IOException {
        OReplicator oReplicator = this;
        synchronized (oReplicator) {
            OOperationLog log = this.localLogs.get(dbName);
            if (log == null) {
                log = new OOperationLog(this.manager.getId(), dbName, false);
                this.localLogs.put(dbName, log);
            }
            return log;
        }
    }

    public static enum STATUS {
        OFFLINE,
        ONLINE,
        SYNCHRONIZING;

    }
}

