/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.replication;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.distributed.OReplicationActiveThreadLocal;
import com.orientechnologies.orient.server.replication.ODistributedSynchronizationException;
import com.orientechnologies.orient.server.replication.OReplicator;
import java.io.IOException;

public class OReplicatorRecordHook
implements ORecordHook,
ODatabaseLifecycleListener {
    private OReplicator replicator;

    public OReplicatorRecordHook(OReplicator iReplicator) {
        this.replicator = iReplicator;
        Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
    }

    public boolean onTrigger(ORecordHook.TYPE iType, ORecord<?> iRecord) {
        if (!((Boolean)OReplicationActiveThreadLocal.INSTANCE.get()).booleanValue()) {
            return false;
        }
        if (iRecord instanceof ODocument && this.replicator.isIgnoredDocumentClass(((ODocument)iRecord).getClassName())) {
            return false;
        }
        if (!this.replicator.isReplicated(iRecord.getDatabase().getName())) {
            return false;
        }
        try {
            switch (iType) {
                case AFTER_CREATE: {
                    if (!this.checkRecord(iRecord)) break;
                    this.replicator.distributeRequest(new ORecordOperation((OIdentifiable)((ORecordInternal)iRecord), 3));
                    break;
                }
                case AFTER_UPDATE: {
                    if (!this.checkRecord(iRecord)) break;
                    this.replicator.distributeRequest(new ORecordOperation((OIdentifiable)((ORecordInternal)iRecord), 1));
                    break;
                }
                case AFTER_DELETE: {
                    if (!this.checkRecord(iRecord)) break;
                    this.replicator.distributeRequest(new ORecordOperation((OIdentifiable)((ORecordInternal)iRecord), 2));
                }
            }
        }
        catch (IOException e) {
            throw new ODistributedSynchronizationException("Error on distribution of the record to the configured cluster", e);
        }
        return false;
    }

    public void onOpen(ODatabase iDatabase) {
        ((ODatabaseComplex)iDatabase).registerHook((ORecordHook)this);
    }

    public void onClose(ODatabase iDatabase) {
        ((ODatabaseComplex)iDatabase).unregisterHook((ORecordHook)this);
    }

    protected boolean checkRecord(ORecord<?> iRecord) {
        int clId = iRecord.getIdentity().getClusterId();
        if (clId == iRecord.getDatabase().getClusterIdByName("internal") || clId == iRecord.getDatabase().getClusterIdByName("index")) {
            OLogManager.instance().warn((Object)this, "Changes to the cluster %s.%s cannot be propagated to remote nodes. Assure to align the schema manually", new Object[]{iRecord.getDatabase().getName(), "internal"});
            return false;
        }
        return true;
    }
}

