/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public class OClientConnectionManager
extends OSharedResourceAbstract {
    protected Map<Integer, OClientConnection> connections = new HashMap<Integer, OClientConnection>();
    protected int connectionSerial = 0;
    private static final OClientConnectionManager instance = new OClientConnectionManager();

    public OClientConnectionManager() {
        int delay = OGlobalConfiguration.SERVER_CHANNEL_CLEAN_DELAY.getValueAsInteger();
        Orient.getTimer().schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OClientConnectionManager.this.acquireExclusiveLock();
                try {
                    HashMap<Integer, OClientConnection> localConnections = new HashMap<Integer, OClientConnection>(OClientConnectionManager.this.connections);
                    for (Map.Entry<Integer, OClientConnection> entry : localConnections.entrySet()) {
                        Socket socket = entry.getValue().protocol.getChannel().socket;
                        if (socket != null && !socket.isClosed() && !socket.isInputShutdown()) continue;
                        OLogManager.instance().debug((Object)this, "[OClientConnectionManager] found and removed pending closed channel %d (%s)", new Object[]{entry.getKey(), socket});
                        try {
                            entry.getValue().close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        OClientConnectionManager.this.connections.remove(entry.getKey());
                    }
                }
                finally {
                    OClientConnectionManager.this.releaseExclusiveLock();
                }
            }
        }, delay, (long)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClientConnection connect(Socket iSocket, ONetworkProtocol iProtocol) throws IOException {
        OClientConnection connection;
        OProfiler.getInstance().updateCounter("server.connections.actives", 1L);
        this.acquireExclusiveLock();
        try {
            connection = new OClientConnection(++this.connectionSerial, iProtocol);
            this.connections.put(connection.id, connection);
        }
        finally {
            this.releaseExclusiveLock();
        }
        OLogManager.instance().config((Object)this, "Remote client connected from: " + connection, new Object[0]);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClientConnection getConnection(Socket socket, int iChannelId) {
        this.acquireSharedLock();
        try {
            OClientConnection conn = null;
            OClientConnection oClientConnection = conn = this.connections.get(iChannelId);
            return oClientConnection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnect(int iChannelId) {
        block5: {
            OProfiler.getInstance().updateCounter("server.connections.actives", -1L);
            this.acquireExclusiveLock();
            try {
                OClientConnection connection = this.connections.remove(iChannelId);
                if (connection == null) break block5;
                connection.close();
                for (Map.Entry<Integer, OClientConnection> entry : this.connections.entrySet()) {
                    if (!((Object)((Object)entry.getValue().getProtocol())).equals((Object)connection.getProtocol())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(OClientConnection connection) {
        OProfiler.getInstance().updateCounter("server.connections.actives", -1L);
        connection.close();
        this.acquireExclusiveLock();
        try {
            for (Map.Entry<Integer, OClientConnection> entry : new HashMap<Integer, OClientConnection>(this.connections).entrySet()) {
                if (!entry.getValue().equals(connection)) continue;
                this.connections.remove(entry.getKey());
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public static OClientConnectionManager instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OClientConnection> getConnections() {
        this.acquireSharedLock();
        try {
            ArrayList<OClientConnection> arrayList = new ArrayList<OClientConnection>(this.connections.values());
            return arrayList;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDistribCfg2Clients(ODocument iConfig) {
        byte[] content = iConfig.toStream();
        this.acquireSharedLock();
        try {
            HashSet<String> pushed = new HashSet<String>();
            for (OClientConnection c : this.connections.values()) {
                if (pushed.contains(c.getRemoteAddress()) || !(c.protocol instanceof ONetworkProtocolBinary)) continue;
                ONetworkProtocolBinary p = (ONetworkProtocolBinary)c.protocol;
                OChannelBinary channel = (OChannelBinary)p.getChannel();
                channel.acquireExclusiveLock();
                try {
                    channel.writeByte((byte)3);
                    channel.writeInt(Integer.MIN_VALUE);
                    channel.writeByte((byte)80);
                    channel.writeBytes(content);
                    channel.flush();
                    pushed.add(c.getRemoteAddress());
                    OLogManager.instance().info((Object)this, "Sent updated cluster configuration to the remote client %s", new Object[]{c.getRemoteAddress()});
                }
                catch (IOException e) {
                    OLogManager.instance().warn((Object)this, "Cannot push cluster configuration to client %s", new Object[]{c.getRemoteAddress()});
                }
                finally {
                    channel.releaseExclusiveLock();
                }
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pushRecord2Clients(ORecordInternal<?> iRecord, OClientConnection iExcludeConnection) throws InterruptedException, IOException {
        this.acquireSharedLock();
        try {
            String dbName = iRecord.getDatabase().getName();
            for (OClientConnection c : this.connections.values()) {
                if (c == iExcludeConnection) continue;
                ONetworkProtocolBinary p = (ONetworkProtocolBinary)c.protocol;
                OChannelBinary channel = (OChannelBinary)p.getChannel();
                if (c.database == null || !c.database.getName().equals(dbName)) continue;
                OClientConnection oClientConnection = c;
                synchronized (oClientConnection) {
                    channel.acquireExclusiveLock();
                    try {
                        channel.writeByte((byte)3);
                        channel.writeInt(Integer.MIN_VALUE);
                        channel.writeByte((byte)79);
                        p.writeIdentifiable((OIdentifiable)iRecord);
                    }
                    finally {
                        channel.releaseExclusiveLock();
                    }
                }
            }
            return;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClientConnection getConnection(String iAddress) {
        this.acquireSharedLock();
        try {
            for (OClientConnection conn : this.connections.values()) {
                if (!iAddress.equals(conn.getRemoteAddress())) continue;
                OClientConnection oClientConnection = conn;
                return oClientConnection;
            }
            OClientConnection oClientConnection = null;
            return oClientConnection;
        }
        finally {
            this.releaseSharedLock();
        }
    }
}

