/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.memory.OStorageMemory;
import com.orientechnologies.orient.server.OServerLifecycleListener;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.OServerShutdownHook;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationLoaderXml;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.handler.OServerHandler;
import com.orientechnologies.orient.server.managed.OrientServer;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OServer {
    protected ReentrantLock lock = new ReentrantLock();
    protected volatile boolean running = true;
    protected OServerConfigurationLoaderXml configurationLoader;
    protected OServerConfiguration configuration;
    protected OContextConfiguration contextConfiguration;
    protected OServerShutdownHook shutdownHook;
    protected Map<String, OServerHandler> plugins = new HashMap<String, OServerHandler>();
    protected Map<String, Class<? extends ONetworkProtocol>> networkProtocols = new HashMap<String, Class<? extends ONetworkProtocol>>();
    protected List<OServerNetworkListener> networkListeners = new ArrayList<OServerNetworkListener>();
    protected List<OServerLifecycleListener> lifecycleListeners = new ArrayList<OServerLifecycleListener>();
    protected ODistributedServerManager distributedManager;
    protected static ThreadGroup threadGroup;
    private OrientServer managedServer;
    private ObjectName onProfiler = new ObjectName("OrientDB:type=Profiler");
    private ObjectName onServer = new ObjectName("OrientDB:type=Server");
    private final CountDownLatch startupLatch = new CountDownLatch(1);
    private Random random = new Random();
    private Map<String, Object> variables = new HashMap<String, Object>();

    public OServer() throws ClassNotFoundException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.defaultSettings();
        OLogManager.installCustomFormatter();
        threadGroup = new ThreadGroup("OrientDB Server");
        OGlobalConfiguration.STORAGE_KEEP_OPEN.setValue((Object)true);
        System.setProperty("com.sun.management.jmxremote", "true");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        mBeanServer.registerMBean(OProfiler.getInstance().startRecording(), this.onProfiler);
        this.managedServer = new OrientServer();
        mBeanServer.registerMBean(this.managedServer, this.onServer);
        this.shutdownHook = new OServerShutdownHook();
    }

    public void startup() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        String config = "config/orientdb-server-config.xml";
        if (System.getProperty("orientdb.config.file") != null) {
            config = System.getProperty("orientdb.config.file");
        }
        this.startup(new File(config));
    }

    public void startup(File iConfigurationFile) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        this.startup(this.loadConfigurationFromFile(iConfigurationFile));
    }

    public void startup(String iConfiguration) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        this.startup(new ByteArrayInputStream(iConfiguration.getBytes()));
    }

    public void startup(InputStream iInputStream) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iInputStream);
        this.configuration = this.configurationLoader.load();
        this.startup(this.configuration);
    }

    public void startup(OServerConfiguration iConfiguration) throws IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        OLogManager.instance().info((Object)this, "OrientDB Server v" + OConstants.getVersion() + " is starting up...", new Object[0]);
        Orient.instance();
        this.loadConfiguration(iConfiguration);
        if (OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP.getValueAsBoolean()) {
            System.out.println("Dumping environment after server startup...");
            OGlobalConfiguration.dumpConfiguration((PrintStream)System.out);
        }
    }

    public void activate() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
            oServerLifecycleListener.onBeforeActivate();
        }
        for (OServerNetworkProtocolConfiguration oServerNetworkProtocolConfiguration : this.configuration.network.protocols) {
            this.networkProtocols.put(oServerNetworkProtocolConfiguration.name, Class.forName(oServerNetworkProtocolConfiguration.implementation));
        }
        for (OServerNetworkListenerConfiguration oServerNetworkListenerConfiguration : this.configuration.network.listeners) {
            this.networkListeners.add(new OServerNetworkListener(this, oServerNetworkListenerConfiguration.ipAddress, oServerNetworkListenerConfiguration.portRange, oServerNetworkListenerConfiguration.protocol, this.networkProtocols.get(oServerNetworkListenerConfiguration.protocol), oServerNetworkListenerConfiguration.parameters, oServerNetworkListenerConfiguration.commands));
        }
        this.registerPlugins();
        for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
            oServerLifecycleListener.onAfterActivate();
        }
        OLogManager.instance().info((Object)this, "OrientDB Server v1.1.0 is active.", new Object[0]);
        this.startupLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.shutdownHook.cancel();
        for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
            oServerLifecycleListener.onBeforeDeactivate();
        }
        OLogManager.instance().info((Object)this, "OrientDB Server is shutdowning...", new Object[0]);
        try {
            Orient.instance().shutdown();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.lock.lock();
            if (this.plugins.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutdowning plugins:", new Object[0]);
                for (OServerHandler oServerHandler : this.plugins.values()) {
                    OLogManager.instance().info((Object)this, "- %s", new Object[]{oServerHandler.getName()});
                    try {
                        oServerHandler.sendShutdown();
                    }
                    catch (Throwable t) {}
                }
            }
            if (this.networkProtocols.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutdowning protocols", new Object[0]);
                this.networkProtocols.clear();
            }
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.unregisterMBean(this.onProfiler);
                mBeanServer.unregisterMBean(this.onServer);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "OrientDB Server v1.1.0 unregisterMBean error.", (Throwable)e, new Object[0]);
            }
            if (this.networkListeners.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutdowning listeners:", new Object[0]);
                for (OServerNetworkListener oServerNetworkListener : this.networkListeners) {
                    OLogManager.instance().info((Object)this, "- %s", new Object[]{oServerNetworkListener});
                    try {
                        oServerNetworkListener.shutdown();
                    }
                    catch (Throwable e) {}
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
            try {
                oServerLifecycleListener.onAfterDeactivate();
            }
            catch (Exception exception) {}
        }
        OLogManager.instance().info((Object)this, "OrientDB Server shutdown complete", new Object[0]);
        System.out.println();
    }

    public String getStoragePath(String iName) {
        String name = iName.indexOf(58) > -1 ? iName.substring(iName.indexOf(58) + 1) : iName;
        OStorage stg = Orient.instance().getStorage(name);
        if (stg != null) {
            return stg.getURL();
        }
        String dbPath = this.configuration.getStoragePath(name);
        if (dbPath == null) {
            dbPath = OSystemVariableResolver.resolveSystemVariables((String)("${ORIENTDB_HOME}/databases/" + name + "/"));
            File f = new File(dbPath + "default.odh");
            if (!f.exists()) {
                throw new OConfigurationException("Database '" + name + "' is not configured on server");
            }
            dbPath = "local:${ORIENTDB_HOME}/databases/" + name;
        }
        return dbPath;
    }

    public Map<String, String> getAvailableStorageNames() {
        HashMap<String, String> storages = new HashMap<String, String>();
        if (this.configuration.storages != null && this.configuration.storages.length > 0) {
            for (OServerStorageConfiguration s : this.configuration.storages) {
                storages.put(s.name, s.path);
            }
        }
        String rootDirectory = this.getDatabaseDirectory();
        this.scanDatabaseDirectory(rootDirectory, new File(rootDirectory), storages);
        for (OStorage storage : Orient.instance().getStorages()) {
            String storageName = storage.getName();
            if (storages.containsKey(storageName)) continue;
            storages.put(storageName, storage.getURL());
        }
        return storages;
    }

    public String getStorageURL(String iName) {
        if (this.configuration.storages != null && this.configuration.storages.length > 0) {
            for (OServerStorageConfiguration s : this.configuration.storages) {
                if (!s.name.equals(iName)) continue;
                return s.path;
            }
        }
        HashMap<String, String> storages = new HashMap<String, String>();
        String rootDirectory = this.getDatabaseDirectory();
        this.scanDatabaseDirectory(rootDirectory, new File(rootDirectory), storages);
        return (String)storages.get(iName);
    }

    public String getDatabaseDirectory() {
        return OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/databases/");
    }

    public ThreadGroup getServerThreadGroup() {
        return threadGroup;
    }

    public OServerUserConfiguration serverLogin(String iUser, String iPassword, String iResource) {
        if (!this.authenticate(iUser, iPassword, iResource)) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance. Get the user/password from the config/orientdb-server-config.xml file");
        }
        return this.getUser(iUser);
    }

    public boolean authenticate(String iUserName, String iPassword, String iResourceToCheck) {
        OServerUserConfiguration user = this.getUser(iUserName);
        if (user != null && (iPassword == null || user.password.equals(iPassword))) {
            String[] resourceParts;
            if (user.resources.equals("*")) {
                return true;
            }
            for (String r : resourceParts = user.resources.split(",")) {
                if (!r.equals(iResourceToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public OServerUserConfiguration getUser(String iUserName) {
        return this.configuration.getUser(iUserName);
    }

    public boolean existsStoragePath(String iURL) {
        return this.configuration.getStoragePath(iURL) != null;
    }

    public OServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void saveConfiguration() throws IOException {
        this.configurationLoader.save(this.configuration);
    }

    public Map<String, Class<? extends ONetworkProtocol>> getNetworkProtocols() {
        return this.networkProtocols;
    }

    public List<OServerNetworkListener> getNetworkListeners() {
        return this.networkListeners;
    }

    public <RET extends OServerNetworkListener> RET getListenerByProtocol(Class<? extends ONetworkProtocol> iProtocolClass) {
        for (OServerNetworkListener l : this.networkListeners) {
            if (!l.getProtocolType().equals(iProtocolClass)) continue;
            return (RET)l;
        }
        return null;
    }

    public OrientServer getManagedServer() {
        return this.managedServer;
    }

    public Collection<OServerHandler> getPlugins() {
        return this.plugins.values();
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public <RET extends OServerHandler> RET getHandler(Class<RET> iHandlerClass) {
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (OServerHandler h : this.plugins.values()) {
            if (!h.getClass().equals(iHandlerClass)) continue;
            return (RET)h;
        }
        return null;
    }

    public <RET extends OServerHandler> RET getPlugin(String iName) {
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return (RET)this.plugins.get(iName);
    }

    public Object getVariable(String iName) {
        return this.variables.get(iName);
    }

    public OServer setVariable(String iName, Object iValue) {
        if (iValue == null) {
            this.variables.remove(iName);
        } else {
            this.variables.put(iName, iValue);
        }
        return this;
    }

    protected void loadConfiguration(OServerConfiguration iConfiguration) {
        try {
            this.configuration = iConfiguration;
            this.contextConfiguration = new OContextConfiguration();
            if (iConfiguration.properties != null) {
                for (OServerEntryConfiguration prop : iConfiguration.properties) {
                    this.contextConfiguration.setValue(prop.name, (Object)prop.value);
                }
            }
            this.loadStorages();
            this.loadUsers();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on reading server configuration.", OConfigurationException.class);
        }
    }

    protected OServerConfiguration loadConfigurationFromFile(File iFile) {
        try {
            this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iFile);
            return this.configurationLoader.load();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on reading server configuration from file: " + iFile, (Throwable)e, OConfigurationException.class, new Object[0]);
            return null;
        }
    }

    protected void loadUsers() throws IOException {
        if (this.configuration.users != null && this.configuration.users.length > 0) {
            for (OServerUserConfiguration u : this.configuration.users) {
                if (!u.name.equals("root")) continue;
                return;
            }
        }
        this.createAdminAndDbListerUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadStorages() {
        if (this.configuration.storages == null) {
            return;
        }
        for (OServerStorageConfiguration stg : this.configuration.storages) {
            if (!stg.loadOnStartup) continue;
            if (stg.userName == null) {
                stg.userName = "admin";
            }
            if (stg.userPassword == null) {
                stg.userPassword = "admin";
            }
            String type = stg.path.substring(0, stg.path.indexOf(58));
            ODatabaseDocumentTx db = null;
            try {
                db = new ODatabaseDocumentTx(stg.path);
                if (db.exists()) {
                    db.open(stg.userName, stg.userPassword);
                } else {
                    db.create();
                    if (stg.userName.equals("admin")) {
                        if (!stg.userPassword.equals("admin")) {
                            db.getMetadata().getSecurity().getUser("admin").setPassword(stg.userPassword);
                        }
                    } else {
                        db.getMetadata().getSecurity().createUser(stg.userName, stg.userPassword, new String[]{"admin"});
                        db.getMetadata().getSecurity().dropUser("admin");
                        db.close();
                        db.open(stg.userName, stg.userPassword);
                    }
                }
                OLogManager.instance().info((Object)this, "-> Loaded " + type + " database '" + stg.name + "'", new Object[0]);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "-> Cannot load " + type + " database '" + stg.name + "': " + e, new Object[0]);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    public void addUser(String iName, String iPassword, String iPermissions) throws IOException {
        if (iName == null || iName.length() == 0) {
            throw new IllegalArgumentException("User name null or empty");
        }
        if (iPermissions == null || iPermissions.length() == 0) {
            throw new IllegalArgumentException("User permissions null or empty");
        }
        this.configuration.users = this.configuration.users == null ? new OServerUserConfiguration[1] : Arrays.copyOf(this.configuration.users, this.configuration.users.length + 1);
        if (iPassword == null) {
            iPassword = OSecurityManager.instance().digest2String(String.valueOf(this.random.nextLong()), false);
        }
        this.configuration.users[this.configuration.users.length - 1] = new OServerUserConfiguration(iName, iPassword, iPermissions);
        this.saveConfiguration();
    }

    public OServer registerLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.add(iListener);
        return this;
    }

    public OServer unregisterLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.remove(iListener);
        return this;
    }

    protected void createAdminAndDbListerUsers() throws IOException {
        this.addUser("root", null, "*");
        this.addUser("guest", "guest", "connect,server.listDatabases");
        this.saveConfiguration();
    }

    protected void registerPlugins() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.configuration.handlers != null) {
            for (OServerHandlerConfiguration h : this.configuration.handlers) {
                OServerHandler handler = (OServerHandler)Class.forName(h.clazz).newInstance();
                this.plugins.put(handler.getName(), handler);
                handler.config(this, h.parameters);
                handler.startup();
                if (!(handler instanceof ODistributedServerManager)) continue;
                this.distributedManager = (ODistributedServerManager)((Object)handler);
            }
        }
    }

    protected void defaultSettings() {
        OGlobalConfiguration.TX_USE_LOG.setValue((Object)true);
        OGlobalConfiguration.TX_COMMIT_SYNCH.setValue((Object)true);
    }

    protected void scanDatabaseDirectory(String iRootDirectory, File iDirectory, Map<String, String> iStorages) {
        if (iDirectory.exists() && iDirectory.isDirectory()) {
            for (File db : iDirectory.listFiles()) {
                if (!db.isDirectory()) continue;
                File f = new File(db.getAbsolutePath() + "/default.odh");
                if (f.exists()) {
                    String dbPath = db.getPath().replace('\\', '/');
                    iStorages.put(dbPath.substring(iRootDirectory.length()), "local:" + dbPath);
                    continue;
                }
                this.scanDatabaseDirectory(iRootDirectory, db, iStorages);
            }
        }
    }

    public ODatabaseComplex<?> openDatabase(String iDbType, String iDbUrl, String iUser, String iPassword) {
        String path = OServerMain.server().getStoragePath(iDbUrl);
        ODatabaseDocumentTx database = Orient.instance().getDatabaseFactory().createDatabase(iDbType, path);
        if (database.isClosed()) {
            if (database.getStorage() instanceof OStorageMemory) {
                database.create();
            } else {
                try {
                    database.open(iUser, iPassword);
                }
                catch (OSecurityException e) {
                    try {
                        OServerMain.server().serverLogin(iUser, iPassword, "database.passthrough");
                    }
                    catch (OSecurityException ex) {
                        throw e;
                    }
                    database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), (Object)Boolean.FALSE);
                    database.open(iUser, iPassword);
                }
            }
        }
        return database;
    }

    public ODistributedServerManager getDistributedManager() {
        return this.distributedManager;
    }
}

