/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.handler.OServerHandlerAbstract;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ODistributedAbstractPlugin
extends OServerHandlerAbstract
implements ODistributedServerManager,
ODatabaseLifecycleListener {
    public static final String REPLICATOR_USER = "replicator";
    protected static final String PAR_DEF_DISTRIB_DB_CONFIG = "configuration.db.default";
    protected static final String FILE_DISTRIBUTED_DB_CONFIG = "distributed-config.json";
    protected OServer serverInstance;
    protected Map<String, OStorageSynchronizer> synchronizers = new HashMap<String, OStorageSynchronizer>();
    protected Map<String, ODocument> databaseConfiguration = new HashMap<String, ODocument>();
    protected boolean enabled = true;
    protected String alias = null;
    protected Class<? extends OReplicationConflictResolver> confictResolverClass;
    protected boolean alignmentStartup;
    protected int alignmentTimer;

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.serverInstance = oServer;
        oServer.setVariable("ODistributedAbstractPlugin", this);
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(param.value)) continue;
                this.enabled = false;
                return;
            }
            if (param.name.equalsIgnoreCase("alias")) {
                this.alias = param.value;
                continue;
            }
            if (param.name.startsWith(PAR_DEF_DISTRIB_DB_CONFIG)) {
                if (this.loadDatabaseConfiguration("*", OSystemVariableResolver.resolveSystemVariables((String)param.value)) != null) continue;
                throw new OConfigurationException("Error on loading distributed database configuration");
            }
            if (param.name.equalsIgnoreCase("conflict.resolver.impl")) {
                try {
                    this.confictResolverClass = Class.forName(param.value);
                }
                catch (ClassNotFoundException e) {
                    OLogManager.instance().error((Object)this, "Cannot find the conflict resolver implementation '%s'", new Object[]{param.value, e});
                }
                continue;
            }
            if (param.name.equalsIgnoreCase("alignment.startup")) {
                this.alignmentStartup = Boolean.parseBoolean(param.value);
                continue;
            }
            if (!param.name.equalsIgnoreCase("alignment.timer")) continue;
            this.alignmentTimer = Integer.parseInt(param.value);
        }
        if (!this.databaseConfiguration.containsKey("*")) {
            throw new OConfigurationException("Invalid cluster configuration: cannot find settings 'configuration.db.default' for the default database");
        }
        if (this.serverInstance.getUser(REPLICATOR_USER) == null) {
            try {
                this.serverInstance.addUser(REPLICATOR_USER, null, "database.passthrough");
                this.serverInstance.saveConfiguration();
            }
            catch (IOException e) {
                throw new OConfigurationException("Error on creating 'replicator' user", (Throwable)e);
            }
        }
    }

    @Override
    public void startup() {
        if (!this.enabled) {
            return;
        }
        super.startup();
        Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
    }

    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        Orient.instance().removeDbLifecycleListener((ODatabaseLifecycleListener)this);
        super.shutdown();
    }

    public void onOpen(ODatabase iDatabase) {
        ODocument cfg = this.getDatabaseConfiguration(iDatabase.getName());
        if (cfg == null) {
            return;
        }
        Boolean synch = (Boolean)cfg.field("synchronization");
        if (synch == null || synch.booleanValue()) {
            OStorageSynchronizer dbSynchronizer = this.getDatabaseSynchronizer(iDatabase.getName());
            if (iDatabase instanceof ODatabaseComplex) {
                ((ODatabaseComplex)iDatabase).replaceStorage((OStorage)new ODistributedStorage(this, dbSynchronizer, (OStorageEmbedded)((ODatabaseComplex)iDatabase).getStorage()));
            }
        }
    }

    public void onClose(ODatabase iDatabase) {
    }

    @Override
    public void sendShutdown() {
        super.sendShutdown();
    }

    public String getName() {
        return "cluster";
    }

    @Override
    public String getLocalNodeId() {
        return this.alias;
    }

    @Override
    public ODocument getDatabaseConfiguration(String iDatabaseName) {
        ODocument cfg = this.databaseConfiguration.get(iDatabaseName);
        if (cfg == null && (cfg = this.loadDatabaseConfiguration(iDatabaseName, this.serverInstance.getDatabaseDirectory() + iDatabaseName + "/" + FILE_DISTRIBUTED_DB_CONFIG)) == null) {
            cfg = this.databaseConfiguration.get("*");
            this.saveDatabaseConfiguration(iDatabaseName, cfg);
        }
        return cfg;
    }

    public void setDefaultDatabaseConfiguration(String iDatabaseName, ODocument iConfiguration) {
        this.databaseConfiguration.put(iDatabaseName, iConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorageSynchronizer getDatabaseSynchronizer(String iDatabaseName) {
        Map<String, OStorageSynchronizer> map = this.synchronizers;
        synchronized (map) {
            OStorageSynchronizer sync = this.synchronizers.get(iDatabaseName);
            if (sync == null) {
                try {
                    sync = new OStorageSynchronizer(this, iDatabaseName);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new ODistributedException("Cannot get the storage synchronizer for database " + iDatabaseName, e);
                }
                this.synchronizers.put(iDatabaseName, sync);
            }
            return sync;
        }
    }

    @Override
    public Collection<String> getSynchronousReplicaNodes(String iDatabaseName, String iClusterName, Object iKey) {
        return this.getReplicaNodes("synch-replicas", iDatabaseName, iClusterName, iKey);
    }

    @Override
    public Collection<String> getAsynchronousReplicaNodes(String iDatabaseName, String iClusterName, Object iKey) {
        return this.getReplicaNodes("asynch-replicas", iDatabaseName, iClusterName, iKey);
    }

    protected Collection<String> getReplicaNodes(String iMode, String iDatabaseName, String iClusterName, Object iKey) {
        ArrayList<String> result;
        block9: {
            Set remoteNodes;
            Object replicas;
            block10: {
                replicas = this.getDatabaseClusterConfiguration(iDatabaseName, iClusterName).field(iMode);
                if (replicas == null) {
                    replicas = this.getDatabaseClusterConfiguration(iDatabaseName, "*").field(iMode);
                }
                if (replicas == null) {
                    return Collections.emptyList();
                }
                remoteNodes = this.getRemoteNodeIds();
                result = new ArrayList<String>();
                if (!(replicas instanceof String) && !(replicas instanceof Integer)) break block10;
                int tot = 0;
                if (replicas instanceof String) {
                    String replicasAsText = (String)replicas;
                    if (replicasAsText.charAt(replicasAsText.length() - 1) == '%') {
                        int perc = Integer.parseInt(replicasAsText.substring(0, replicasAsText.length() - 1));
                        tot = Math.round(perc * remoteNodes.size() / 100);
                    } else {
                        tot = Integer.parseInt(replicasAsText);
                    }
                } else {
                    tot = (Integer)replicas;
                }
                for (String nodeId : remoteNodes) {
                    if (result.size() <= tot) {
                        result.add(nodeId);
                        continue;
                    }
                    break block9;
                }
                break block9;
            }
            if (!(replicas instanceof Collection)) break block9;
            Collection nodeCollection = (Collection)replicas;
            for (String nodeId : nodeCollection) {
                if (!remoteNodes.contains(nodeId)) continue;
                result.add(nodeId);
            }
        }
        return result;
    }

    protected ODocument getDatabaseClusterConfiguration(String iDbName, String iClusterName) {
        ODocument clusters = (ODocument)this.getDatabaseConfiguration(iDbName).field("clusters");
        if (clusters == null) {
            throw new OConfigurationException("Cannot find 'clusters' in distributed database configuration");
        }
        ODocument cfg = (ODocument)clusters.field(iClusterName);
        if (cfg == null) {
            cfg = (ODocument)clusters.field("*");
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ODocument loadDatabaseConfiguration(String iDatabaseName, String filePath) {
        File file = new File(filePath);
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        OLogManager.instance().config((Object)this, "Loading distributed configuration for database '%s'", new Object[]{iDatabaseName});
        FileInputStream f = null;
        try {
            f = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            f.read(buffer);
            ODocument doc = (ODocument)new ODocument().fromJSON(new String(buffer), "noMap");
            this.databaseConfiguration.put(iDatabaseName, doc);
            ODocument oDocument = doc;
            return oDocument;
        }
        catch (Exception e) {
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDatabaseConfiguration(String iDatabaseName, ODocument cfg) {
        File file = new File(this.serverInstance.getDatabaseDirectory() + iDatabaseName + "/" + FILE_DISTRIBUTED_DB_CONFIG);
        this.databaseConfiguration.put(iDatabaseName, cfg);
        OLogManager.instance().config((Object)this, "Saving distributed configuration for database '%s'", new Object[]{iDatabaseName});
        FileOutputStream f = null;
        try {
            f = new FileOutputStream(file);
            f.write(cfg.toJSON().getBytes());
        }
        catch (Exception e) {
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

