/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.command.OCommandDistributedConditionalReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedThreadLocal;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.task.OCreateRecordDistributedTask;
import com.orientechnologies.orient.server.task.ODeleteRecordDistributedTask;
import com.orientechnologies.orient.server.task.OReadRecordDistributedTask;
import com.orientechnologies.orient.server.task.OSQLCommandDistributedTask;
import com.orientechnologies.orient.server.task.OUpdateRecordDistributedTask;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class ODistributedStorage
implements OStorage {
    protected ODistributedServerManager dManager;
    protected OStorageEmbedded wrapped;
    protected OStorageSynchronizer dbSynchronizer;
    protected boolean eventuallyConsistent = true;
    protected ODistributedServerManager.EXECUTION_MODE createRecordMode = ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS;
    protected ODistributedServerManager.EXECUTION_MODE updateRecordMode = ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS;
    protected ODistributedServerManager.EXECUTION_MODE deleteRecordMode = ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS;

    public ODistributedStorage(ODistributedServerManager iCluster, OStorageSynchronizer dbSynchronizer, OStorageEmbedded wrapped) {
        this.dManager = iCluster;
        this.wrapped = wrapped;
        this.dbSynchronizer = dbSynchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object command(OCommandRequestText iCommand) {
        OCommandExecutor exec;
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse((OCommandRequest)iCommand);
        Object object = exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
        boolean distribute = exec instanceof OCommandDistributedConditionalReplicateRequest ? ((OCommandDistributedConditionalReplicateRequest)exec).isReplicated() : exec instanceof OCommandDistributedReplicateRequest;
        if (distribute) {
            ODistributedThreadLocal.INSTANCE.distributedExecution = true;
        }
        try {
            Object localResult = this.wrapped.executeCommand(iCommand, executor);
            if (distribute) {
                Map<String, Object> distributedResult = this.dManager.sendOperation2Nodes(this.dManager.getRemoteNodeIds(), new OSQLCommandDistributedTask(this.dManager.getLocalNodeId(), this.wrapped.getName(), this.createRecordMode, iCommand.getText()));
                for (Map.Entry<String, Object> entry : distributedResult.entrySet()) {
                    Object remoteResult = entry.getValue();
                    if (localResult == remoteResult || !(localResult == null && remoteResult != null || localResult != null && remoteResult == null) && !remoteResult.equals(localResult)) continue;
                    OReplicationConflictResolver resolver = this.dbSynchronizer.getConflictResolver();
                    resolver.handleCommandConflict(entry.getKey(), (OCommandRequest)iCommand, localResult, remoteResult);
                }
            }
            Object object2 = localResult;
            return object2;
        }
        finally {
            if (distribute) {
                ODistributedThreadLocal.INSTANCE.distributedExecution = false;
            }
        }
    }

    public OPhysicalPosition createRecord(int iDataSegmentId, ORecordId iRecordId, byte[] iContent, int iRecordVersion, byte iRecordType, int iMode, ORecordCallback<Long> iCallback) {
        if (ODistributedThreadLocal.INSTANCE.distributedExecution) {
            return this.wrapped.createRecord(iDataSegmentId, iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
        }
        Object result = null;
        try {
            result = this.dManager.routeOperation2Node(this.getClusterNameFromRID(iRecordId), iRecordId, new OCreateRecordDistributedTask(this.dManager.getLocalNodeId(), this.wrapped.getName(), this.createRecordMode, iRecordId, iContent, iRecordVersion, iRecordType));
            iRecordId.clusterPosition = ((OPhysicalPosition)result).clusterPosition;
        }
        catch (ExecutionException e) {
            throw new OStorageException("Cannot route CREATE_RECORD operation to the distributed node", (Throwable)e);
        }
        return (OPhysicalPosition)result;
    }

    public ORawBuffer readRecord(ORecordId iRecordId, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback) {
        if (ODistributedThreadLocal.INSTANCE.distributedExecution) {
            return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback);
        }
        if (this.eventuallyConsistent || this.dManager.isLocalNodeMaster(iRecordId)) {
            return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback);
        }
        try {
            return (ORawBuffer)this.dManager.routeOperation2Node(this.getClusterNameFromRID(iRecordId), iRecordId, new OReadRecordDistributedTask(this.dManager.getLocalNodeId(), this.wrapped.getName(), iRecordId));
        }
        catch (ExecutionException e) {
            throw new OStorageException("Cannot route READ_RECORD operation to the distributed node", (Throwable)e);
        }
    }

    public int updateRecord(ORecordId iRecordId, byte[] iContent, int iVersion, byte iRecordType, int iMode, ORecordCallback<Integer> iCallback) {
        if (ODistributedThreadLocal.INSTANCE.distributedExecution) {
            return this.wrapped.updateRecord(iRecordId, iContent, iVersion, iRecordType, iMode, iCallback);
        }
        Object result = null;
        try {
            result = this.dManager.routeOperation2Node(this.getClusterNameFromRID(iRecordId), iRecordId, new OUpdateRecordDistributedTask(this.dManager.getLocalNodeId(), this.wrapped.getName(), this.updateRecordMode, iRecordId, iContent, iVersion, iRecordType));
        }
        catch (ExecutionException e) {
            throw new OStorageException("Cannot route UPDATE_RECORD operation to the distributed node", (Throwable)e);
        }
        return (Integer)result;
    }

    public boolean deleteRecord(ORecordId iRecordId, int iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        if (ODistributedThreadLocal.INSTANCE.distributedExecution) {
            return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
        }
        Object result = null;
        try {
            result = this.dManager.routeOperation2Node(this.getClusterNameFromRID(iRecordId), iRecordId, new ODeleteRecordDistributedTask(this.dManager.getLocalNodeId(), this.wrapped.getName(), this.updateRecordMode, iRecordId, iVersion));
        }
        catch (ExecutionException e) {
            throw new OStorageException("Cannot route UPDATE_RECORD operation to the distributed node", (Throwable)e);
        }
        return (Boolean)result;
    }

    public boolean existsResource(String iName) {
        return this.wrapped.existsResource(iName);
    }

    public <T> T removeResource(String iName) {
        return (T)this.wrapped.removeResource(iName);
    }

    public <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.wrapped.getResource(iName, iCallback);
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        this.wrapped.open(iUserName, iUserPassword, iProperties);
    }

    public void create(Map<String, Object> iProperties) {
        this.wrapped.create(iProperties);
    }

    public boolean exists() {
        return this.wrapped.exists();
    }

    public void reload() {
        this.wrapped.reload();
    }

    public void delete() {
        this.wrapped.delete();
    }

    public void close() {
        this.wrapped.close();
    }

    public void close(boolean iForce) {
        this.wrapped.close(iForce);
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    public OLevel2RecordCache getLevel2Cache() {
        return this.wrapped.getLevel2Cache();
    }

    public void commit(OTransaction iTx) {
        throw new ODistributedException("Transactions are not supported in distributed environment");
    }

    public void rollback(OTransaction iTx) {
        throw new ODistributedException("Transactions are not supported in distributed environment");
    }

    public OStorageConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    public int getClusters() {
        return this.wrapped.getClusters();
    }

    public Set<String> getClusterNames() {
        return this.wrapped.getClusterNames();
    }

    public OCluster getClusterById(int iId) {
        return this.wrapped.getClusterById(iId);
    }

    public Collection<? extends OCluster> getClusterInstances() {
        return this.wrapped.getClusterInstances();
    }

    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iParameters) {
        return this.wrapped.addCluster(iClusterType, iClusterName, iLocation, iDataSegmentName, iParameters);
    }

    public boolean dropCluster(String iClusterName) {
        return this.wrapped.dropCluster(iClusterName);
    }

    public boolean dropCluster(int iId) {
        return this.wrapped.dropCluster(iId);
    }

    public int addDataSegment(String iDataSegmentName) {
        return this.wrapped.addDataSegment(iDataSegmentName);
    }

    public int addDataSegment(String iSegmentName, String iDirectory) {
        return this.wrapped.addDataSegment(iSegmentName, iDirectory);
    }

    public long count(int iClusterId) {
        return this.wrapped.count(iClusterId);
    }

    public long count(int[] iClusterIds) {
        return this.wrapped.count(iClusterIds);
    }

    public long getSize() {
        return this.wrapped.getSize();
    }

    public long countRecords() {
        return this.wrapped.countRecords();
    }

    public int getDefaultClusterId() {
        return this.wrapped.getDefaultClusterId();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.wrapped.setDefaultClusterId(defaultClusterId);
    }

    public int getClusterIdByName(String iClusterName) {
        return this.wrapped.getClusterIdByName(iClusterName);
    }

    public String getClusterTypeByName(String iClusterName) {
        return this.wrapped.getClusterTypeByName(iClusterName);
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        return this.wrapped.getPhysicalClusterNameById(iClusterId);
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return this.wrapped.checkForRecordValidity(ppos);
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public String getURL() {
        return this.wrapped.getURL();
    }

    public long getVersion() {
        return this.wrapped.getVersion();
    }

    public void synch() {
        this.wrapped.synch();
    }

    public int getUsers() {
        return this.wrapped.getUsers();
    }

    public int addUser() {
        return this.wrapped.addUser();
    }

    public int removeUser() {
        return this.wrapped.removeUser();
    }

    public long[] getClusterDataRange(int currentClusterId) {
        return this.wrapped.getClusterDataRange(currentClusterId);
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.wrapped.callInLock(iCallable, iExclusiveLock);
    }

    public ODataSegment getDataSegmentById(int iDataSegmentId) {
        return this.wrapped.getDataSegmentById(iDataSegmentId);
    }

    public int getDataSegmentIdByName(String iDataSegmentName) {
        return this.wrapped.getDataSegmentIdByName(iDataSegmentName);
    }

    public boolean dropDataSegment(String iName) {
        return this.wrapped.dropDataSegment(iName);
    }

    public OStorage.STATUS getStatus() {
        return this.wrapped.getStatus();
    }

    protected String getClusterNameFromRID(ORecordId iRecordId) {
        return OStorageSynchronizer.getClusterNameByRID((OStorage)this.wrapped, iRecordId);
    }
}

